/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestRunner;
import org.apache.log4j.Logger;

public abstract class AbstractMockTestRunner<T extends TestRunnable>
implements TestRunner {
    private long startTime;
    private String reason;
    private final T modelItem;
    private final Logger logger;
    private TestRunner.Status status = TestRunner.Status.RUNNING;
    private TestRunContext context;

    public AbstractMockTestRunner(T modelItem, Logger logger) {
        this.modelItem = modelItem;
        this.logger = logger == null ? SoapUI.ensureGroovyLog() : logger;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    public void setRunContext(TestRunContext context) {
        this.context = context;
    }

    @Override
    public TestRunContext getRunContext() {
        return this.context;
    }

    public Logger getLog() {
        return this.logger;
    }

    public T getTestRunnable() {
        return this.modelItem;
    }

    @Override
    public TestRunner.Status getStatus() {
        return this.status;
    }

    @Override
    public void start(boolean async) {
        this.logger.info((Object)("Started with async [" + async + "]"));
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public long getTimeTaken() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public TestRunner.Status waitUntilFinished() {
        this.status = TestRunner.Status.FINISHED;
        return this.status;
    }

    @Override
    public void cancel(String reason) {
        this.reason = reason;
        this.status = TestRunner.Status.CANCELED;
        this.logger.info((Object)("Canceled with reason [" + reason + "]"));
    }

    @Override
    public void fail(String reason) {
        this.reason = reason;
        this.status = TestRunner.Status.FAILED;
        this.logger.error((Object)("Failed with reason [" + reason + "]"));
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getReason() {
        return this.reason;
    }
}

