/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation.actions;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class CreateEmptyWsdlMockResponseAction
extends AbstractAction {
    private final MockResponse mockResponse;

    public CreateEmptyWsdlMockResponseAction(MockResponse mockResponse) {
        super("Create Empty");
        this.mockResponse = mockResponse;
        this.putValue("SmallIcon", UISupport.createImageIcon("/create_empty_request.gif"));
        this.putValue("ShortDescription", "Creates an empty SOAP response");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WsdlOperation operation = (WsdlOperation)this.mockResponse.getMockOperation().getOperation();
        if (operation == null) {
            UISupport.showErrorMessage("Missing operation for this mock response");
            return;
        }
        if (UISupport.confirm("Overwrite current response with empty one?", "Create Empty")) {
            WsdlInterface iface = operation.getInterface();
            this.mockResponse.setResponseContent(iface.getMessageBuilder().buildEmptyMessage());
        }
    }
}

