/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;

public class WsdlMockRequest
extends AbstractMockRequest {
    private SoapVersion soapVersion;
    private String soapAction;
    private Vector<Object> wssResult;

    public WsdlMockRequest(HttpServletRequest request, HttpServletResponse response, WsdlMockRunContext context) throws Exception {
        super(request, response, context);
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    @Override
    public String getProtocol() {
        return super.getProtocol();
    }

    public Vector<?> getWssResult() {
        return this.wssResult;
    }

    @Override
    public void setRequestContent(String requestContent) {
        super.setRequestContent(requestContent);
        this.setRequestXmlObject(null);
        try {
            this.soapVersion = SoapUtils.deduceSoapVersion(this.getRequest().getContentType(), this.getRequestXmlObject());
        }
        catch (XmlException e) {
            SoapUI.logError(e);
        }
        if (this.soapVersion == null) {
            this.soapVersion = SoapVersion.Soap11;
        }
    }

    @Override
    public XmlObject getContentElement() throws XmlException {
        return SoapUtils.getContentElement(this.getRequestXmlObject(), this.soapVersion);
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    @Override
    protected void initProtocolSpecificPostContent(WsdlMockRunContext context, String contentType) throws IOException {
        if (!this.isMultiPart(contentType)) {
            this.addWSSResult(context, this.getRequestContent());
        }
        this.initSoapVersion(contentType);
        this.soapAction = SoapUtils.getSoapAction(this.soapVersion, this.getRequestHeaders());
    }

    private void addWSSResult(WsdlMockRunContext context, String requestContent) throws IOException {
        IncomingWss incoming;
        WsdlMockService mockService = (WsdlMockService)context.getMockService();
        if (StringUtils.hasContent(mockService.getIncomingWss()) && (incoming = mockService.getProject().getWssContainer().getIncomingWssByName(mockService.getIncomingWss())) != null) {
            Document dom = XmlUtils.parseXml(requestContent);
            try {
                this.wssResult = incoming.processIncoming(dom, context);
                if (this.wssResult != null && this.wssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serialize(dom, (Writer)writer);
                    this.setActualRequestContent(requestContent);
                    super.setRequestContent(writer.toString());
                }
            }
            catch (Exception e) {
                if (this.wssResult == null) {
                    this.wssResult = new Vector();
                }
                this.wssResult.add(e);
            }
        }
    }

    private void initSoapVersion(String contentType) {
        try {
            this.soapVersion = SoapUtils.deduceSoapVersion(contentType, this.getRequestXmlObject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.soapVersion == null) {
            this.soapVersion = SoapVersion.Soap11;
        }
    }
}

