/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.data.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.table.TableModel;

public class ExportStatisticsAction
extends AbstractAction {
    private final TableModel model;

    public ExportStatisticsAction(TableModel model) {
        this.model = model;
        this.putValue("SmallIcon", UISupport.createImageIcon("/export.png"));
        this.putValue("ShortDescription", "Export statistics to a file");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.model.getRowCount() == 0) {
                UISupport.showErrorMessage("No data to export!");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(this, "Select file for export");
            if (file == null) {
                return;
            }
            int cnt = this.exportToFile(file);
            UISupport.showInfoMessage("Saved " + cnt + " rows to file [" + file.getName() + "]");
        }
        catch (IOException e1) {
            SoapUI.logError(e1);
        }
    }

    public int exportToFile(File file) throws IOException {
        PrintWriter writer = new PrintWriter(file);
        this.writerHeader(writer);
        int cnt = this.writeData(writer);
        writer.flush();
        writer.close();
        return cnt;
    }

    private int writeData(PrintWriter writer) {
        int c;
        for (c = 0; c < this.model.getRowCount(); ++c) {
            for (int i = 1; i < this.model.getColumnCount(); ++i) {
                if (i > 1) {
                    writer.print(',');
                }
                writer.print(this.model.getValueAt(c, i));
            }
            writer.println();
        }
        return c;
    }

    private void writerHeader(PrintWriter writer) {
        for (int i = 1; i < this.model.getColumnCount(); ++i) {
            if (i > 1) {
                writer.print(',');
            }
            writer.print(this.model.getColumnName(i));
        }
        writer.println();
    }
}

