/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.particles;

import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Particle;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.inferredSchema.MapEntryConfig;
import com.eviware.soapui.inferredSchema.ReferenceParticleConfig;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;

public class ReferenceParticle
implements Particle {
    private Schema schema;
    private Particle reference;
    private QName referenceQName;
    private Map<String, String> attributes;

    public ReferenceParticle(Schema schema, Particle reference) {
        this.schema = schema;
        this.reference = reference;
        this.referenceQName = reference.getName();
        this.attributes = new HashMap<String, String>();
    }

    public ReferenceParticle(ReferenceParticleConfig xml, Schema schema) {
        this.schema = schema;
        this.referenceQName = xml.getReference();
        this.attributes = new HashMap<String, String>();
        for (MapEntryConfig entry : xml.getAttributeList()) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ReferenceParticleConfig save() {
        ReferenceParticleConfig xml = ReferenceParticleConfig.Factory.newInstance();
        xml.setReference(this.referenceQName);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            MapEntryConfig mapEntry = xml.addNewAttribute();
            mapEntry.setKey(entry.getKey());
            mapEntry.setValue(entry.getValue());
        }
        return xml;
    }

    private Particle getReference() {
        if (this.reference == null) {
            this.reference = this.schema.getSystem().getSchemaForNamespace(this.referenceQName.getNamespaceURI()).getParticle(this.referenceQName.getLocalPart());
        }
        return this.reference;
    }

    @Override
    public QName getName() {
        return this.referenceQName;
    }

    @Override
    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        if ((key.equals("minOccurs") || key.equals("maxOccurs")) && value == null) {
            value = "1";
        }
        return value;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public Type getType() {
        return null;
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public void validate(Context context) throws XmlException {
        context.pushPath();
        this.getReference().validate(context);
        context.popPath();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("<" + this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + ":" + (Object)((Object)this.getReference().getPType()) + " ref=\"" + this.schema.getPrefixForNamespace(this.referenceQName.getNamespaceURI()) + ":" + this.referenceQName.getLocalPart() + "\"");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            s.append(" " + entry.getKey() + "=\"" + entry.getValue() + "\"");
        }
        s.append("/>");
        return s.toString();
    }

    @Override
    public Particle.ParticleType getPType() {
        return this.getReference().getPType();
    }
}

