/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.actions;

import com.eviware.soapui.support.HelpActionMarker;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class ShowOnlineHelpAction
extends AbstractAction
implements HelpActionMarker {
    private final String url;
    private String helpurl;

    public ShowOnlineHelpAction(String url) {
        this("Online Help", url, UISupport.getKeyStroke("F1"));
    }

    public ShowOnlineHelpAction(String title, String url) {
        this(title, url, null, null, null);
    }

    public ShowOnlineHelpAction(String title, String url, String description) {
        this(title, url, null, description, null);
    }

    public ShowOnlineHelpAction(String title, String url, String description, String iconPath) {
        this(title, url, null, description, iconPath);
    }

    public ShowOnlineHelpAction(String title, String url, KeyStroke accelerator) {
        this(title, url, accelerator, null);
    }

    public ShowOnlineHelpAction(String title, String url, KeyStroke accelerator, String description) {
        this(title, url, accelerator, description, null);
    }

    public ShowOnlineHelpAction(String title, String url, KeyStroke accelerator, String description, String iconPath) {
        super(title);
        this.url = url;
        this.putValue("ShortDescription", description == null ? "Show online help" : description);
        if (accelerator != null) {
            this.putValue("AcceleratorKey", accelerator);
        }
        this.putValue("SmallIcon", iconPath == null ? UISupport.HELP_ICON : UISupport.createImageIcon(iconPath));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Integer mods = e.getModifiers();
        String helpUrl = Tools.modifyUrl(this.url, mods);
        Tools.openURL(helpUrl);
    }
}

