/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.inspectors.schema;

import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wadl.inference.InferredSchema;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InferredSchemaManager {
    private static Map<RestService, InferredSchema> schemas = new HashMap<RestService, InferredSchema>();
    private static Map<RestService, PropertyChangeSupport> propertyChangeSupports = new HashMap<RestService, PropertyChangeSupport>();
    private static Map<String, String> filenames = new HashMap<String, String>();
    private static Map<String, String> rFilenames = new HashMap<String, String>();

    public static String filenameForNamespace(String namespace) {
        if (!filenames.containsKey(namespace)) {
            filenames.put(namespace, InferredSchemaManager.generateFilename(namespace));
            rFilenames.put(filenames.get(namespace), namespace);
        }
        return filenames.get(namespace);
    }

    public static String namespaceForFilename(String filename) {
        if (!rFilenames.containsKey(filename)) {
            for (InferredSchema is : schemas.values()) {
                for (String ns : is.getNamespaces()) {
                    if (!InferredSchemaManager.filenameForNamespace(ns).equals(filename)) continue;
                    return ns;
                }
            }
        } else {
            return rFilenames.get(filename);
        }
        return null;
    }

    private static String generateFilename(String namespace) {
        if (namespace.equals("")) {
            return "unnamed.xsd";
        }
        return namespace.replaceAll("[^a-zA-Z0-9]", "") + ".xsd";
    }

    public static InferredSchema getInferredSchema(RestService service) {
        if (!schemas.containsKey(service)) {
            try {
                schemas.put(service, InferredSchema.Factory.parse(new ByteArrayInputStream(service.getInferredSchema().getBytes())));
            }
            catch (Exception e) {
                schemas.put(service, InferredSchema.Factory.newInstance());
            }
            propertyChangeSupports.put(service, new PropertyChangeSupport(schemas.get(service)));
        }
        return schemas.get(service);
    }

    public static void save(RestService service) {
        if (schemas.containsKey(service)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String old = service.getInferredSchema();
            try {
                schemas.get(service).save(out);
                service.setInferredSchema(((Object)out).toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            propertyChangeSupports.get(service).firePropertyChange("inferredSchema", old, ((Object)out).toString());
        }
    }

    public static void release(RestService service) {
        schemas.remove(service);
        propertyChangeSupports.remove(service);
    }

    public static void delete(RestService service) {
        service.setInferredSchema(null);
        if (schemas.containsKey(service)) {
            schemas.remove(service);
        }
        propertyChangeSupports.get(service).firePropertyChange("inferredSchema", service.getInferredSchema(), null);
    }

    public static void addPropertyChangeListener(RestService service, PropertyChangeListener listener) {
        if (InferredSchemaManager.getInferredSchema(service) != null) {
            propertyChangeSupports.get(service).addPropertyChangeListener("inferredSchema", listener);
        }
    }

    public static void removePropertyChangeListener(RestService service, PropertyChangeListener listener) {
        propertyChangeSupports.get(service).removePropertyChangeListener("inferredSchema", listener);
    }

    public static void deleteNamespace(RestService service, String ns) {
        InferredSchemaManager.getInferredSchema(service).deleteNamespace(ns);
        InferredSchemaManager.save(service);
    }
}

