/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.panels.component.RestResourceEditor;
import com.eviware.soapui.impl.rest.panels.request.AbstractRestRequestDesktopPanel;
import com.eviware.soapui.impl.rest.panels.request.ParametersField;
import com.eviware.soapui.impl.rest.panels.request.RestRequestMethodModel;
import com.eviware.soapui.impl.rest.panels.request.TextPanelWithTopLabel;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.mutable.MutableBoolean;

public class RestRequestDesktopPanel
extends AbstractRestRequestDesktopPanel<RestRequestInterface, RestRequestInterface> {
    public static final String REST_REQUEST_EDITOR = "rest-request-editor";
    protected TextPanelWithTopLabel resourcePanel;
    protected ParametersField queryPanel;
    private JButton addToTestCaseButton;
    private MutableBoolean updating;

    public RestRequestDesktopPanel(RestRequestInterface modelItem) {
        super(modelItem, modelItem);
        this.setName(REST_REQUEST_EDITOR);
    }

    @Override
    protected void initializeFields() {
        String path = ((RestRequestInterface)this.getRequest()).getResource().getFullPath();
        this.updating = new MutableBoolean();
        this.resourcePanel = new TextPanelWithTopLabel("Resource", path, new RestResourceEditor(((RestRequestInterface)this.getRequest()).getResource(), this.updating));
        this.queryPanel = new ParametersField((RestRequestInterface)this.getRequest());
    }

    @Override
    protected void init(RestRequestInterface request) {
        this.addToTestCaseButton = RestRequestDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("AddRestRequestToTestCaseAction", this.getRequest(), null, "/add_to_test_case.png"), true);
        super.init(request);
    }

    @Override
    protected String getHelpUrl() {
        return "/REST-Testing/working-with-rest-requests.html";
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addToTestCaseButton.setEnabled(enabled);
    }

    @Override
    protected void addTopToolbarComponents(JXToolBar toolBar) {
        this.addResourceAndQueryField(toolBar);
    }

    @Override
    protected void addBottomToolbar(JPanel panel) {
    }

    @Override
    protected void updateUiValues() {
        if (this.updating.booleanValue()) {
            return;
        }
        this.updating.setValue(true);
        this.resourcePanel.setText(((RestRequestInterface)this.getRequest()).getResource().getFullPath());
        this.queryPanel.updateTextField();
        this.updating.setValue(false);
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        toolbar.add(this.addToTestCaseButton);
        JPanel methodPanel = this.addMethodCombo();
        toolbar.addWithOnlyMinimumHeight(methodPanel);
    }

    private JPanel addMethodCombo() {
        JPanel methodPanel = new JPanel(new BorderLayout());
        JComboBox methodComboBox = new JComboBox(new RestRequestMethodModel((RestRequestInterface)this.getRequest()));
        methodComboBox.setSelectedItem((Object)((RestRequestInterface)this.getRequest()).getMethod());
        JLabel methodLabel = new JLabel("Method");
        methodPanel.add((Component)methodLabel, "North");
        methodPanel.add(methodComboBox, "South");
        methodPanel.setMinimumSize(new Dimension(75, 45));
        methodPanel.setMaximumSize(new Dimension(75, 55));
        return methodPanel;
    }

    private void addResourceAndQueryField(JXToolBar toolbar) {
        if (!(this.getRequest() instanceof RestTestRequestInterface)) {
            toolbar.addWithOnlyMinimumHeight(this.resourcePanel);
            toolbar.add(Box.createHorizontalStrut(4));
            toolbar.addWithOnlyMinimumHeight(this.queryPanel);
        }
    }
}

