/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.mock.RestMockAction;
import com.eviware.soapui.impl.rest.mock.RestMockRequest;
import com.eviware.soapui.impl.rest.mock.RestMockResult;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.support.AbstractMockDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestMockDispatcher
extends AbstractMockDispatcher {
    private RestMockService mockService;
    private WsdlMockRunContext mockContext;

    public RestMockDispatcher(RestMockService mockService, WsdlMockRunContext mockContext) {
        this.mockService = mockService;
        this.mockContext = mockContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MockResult dispatchRequest(HttpServletRequest request, HttpServletResponse response) {
        RestMockRequest restMockRequest = null;
        Object result = null;
        try {
            restMockRequest = new RestMockRequest(request, response, this.mockContext);
            result = this.mockService.runOnRequestScript(this.mockContext, restMockRequest);
            if (!(result instanceof MockResult)) {
                result = this.getMockResult(restMockRequest);
            }
            this.mockService.runAfterRequestScript(this.mockContext, (MockResult)result);
            MockResult mockResult = (MockResult)result;
            this.mockService.fireOnMockResult(result);
            return mockResult;
        }
        catch (Exception e) {
            SoapUI.logError(e, "got an exception while dispatching - returning a default 500 response");
            MockResult mockResult = this.createServerErrorMockResult(restMockRequest);
            return mockResult;
        }
        finally {
            this.mockService.fireOnMockResult(result);
        }
    }

    private MockResult createServerErrorMockResult(RestMockRequest restMockRequest) {
        restMockRequest.getHttpResponse().setStatus(500);
        return new RestMockResult(restMockRequest);
    }

    private MockResult getMockResult(RestMockRequest restMockRequest) throws DispatchException {
        String pathToFind = this.getPathRemainder(restMockRequest);
        RestMockAction mockAction = (RestMockAction)this.mockService.findBestMatchedOperation(pathToFind, restMockRequest.getMethod());
        if (mockAction != null) {
            return mockAction.dispatchRequest(restMockRequest);
        }
        return this.createNotFoundResponse(restMockRequest);
    }

    private String getPathRemainder(RestMockRequest restMockRequest) {
        String pathToFind = restMockRequest.getPath();
        if (!this.mockService.getPath().equals("/")) {
            pathToFind = restMockRequest.getPath().substring(this.mockService.getPath().length());
        }
        return pathToFind;
    }

    private RestMockResult createNotFoundResponse(RestMockRequest restMockRequest) {
        restMockRequest.getHttpResponse().setStatus(404);
        return new RestMockResult(restMockRequest);
    }
}

