/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.PropertyExpansionFunction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;

public class OAuth2Parameters {
    private final OAuth2Profile profile;
    final String authorizationUri;
    final String redirectUri;
    final String accessTokenUri;
    final String clientId;
    final String clientSecret;
    final String scope;
    final String refreshToken;
    final String resourceOwnerName;
    final String resourceOwnerPassword;

    public OAuth2Parameters(OAuth2Profile profile) {
        this.profile = profile;
        this.authorizationUri = this.expandProperty(profile, profile.getAuthorizationURI());
        this.redirectUri = this.expandProperty(profile, profile.getRedirectURI());
        this.accessTokenUri = this.expandProperty(profile, profile.getAccessTokenURI());
        this.clientId = this.expandProperty(profile, profile.getClientID());
        this.clientSecret = this.expandProperty(profile, profile.getClientSecret());
        this.scope = this.expandProperty(profile, profile.getScope());
        this.refreshToken = this.expandProperty(profile, profile.getRefreshToken());
        this.resourceOwnerName = this.expandProperty(profile, profile.getResourceOwnerName());
        this.resourceOwnerPassword = this.expandProperty(profile, profile.getResourceOwnerPassword());
    }

    void setAccessTokenInProfile(String accessToken) {
        this.profile.applyRetrievedAccessToken(accessToken);
    }

    public void setRefreshTokenInProfile(String refreshToken) {
        this.profile.setRefreshToken(refreshToken);
    }

    public void setAccessTokenExpirationTimeInProfile(long expirationTime) {
        this.profile.setAccessTokenExpirationTime(expirationTime);
    }

    public void setAccessTokenIssuedTimeInProfile(long issuedTime) {
        this.profile.setAccessTokenIssuedTime(issuedTime);
    }

    public void waitingForAuthorization() {
        this.profile.setAccessTokenStatus(OAuth2Profile.AccessTokenStatus.WAITING_FOR_AUTHORIZATION);
    }

    private String expandProperty(OAuth2Profile profile, String value) {
        return PropertyExpander.expandProperties(profile.getContainer().getProject(), value);
    }

    public void receivedAuthorizationCode() {
        this.profile.setAccessTokenStatus(OAuth2Profile.AccessTokenStatus.RECEIVED_AUTHORIZATION_CODE);
    }

    public void retrivalCanceled() {
        this.profile.setAccessTokenStatus(OAuth2Profile.AccessTokenStatus.RETRIEVAL_CANCELED);
    }

    public void applyRetrievedAccessToken(String accessToken) {
        this.profile.applyRetrievedAccessToken(accessToken);
    }

    public OAuth2Profile.OAuth2Flow getOAuth2Flow() {
        return this.profile.getOAuth2Flow();
    }

    public List<String> getJavaScripts() {
        WsdlProject project = this.profile.getContainer().getProject();
        return Lists.transform(this.profile.getAutomationJavaScripts(), (Function)new PropertyExpansionFunction(project));
    }

    public boolean isAccessTokenRetrivedFromServer() {
        return this.profile.getAccessTokenStatus() == OAuth2Profile.AccessTokenStatus.RETRIEVED_FROM_SERVER;
    }
}

