/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.mock;

import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

public class RestMockServiceOptionsAction
extends AbstractSoapUIAction<RestMockService> {
    private XFormDialog dialog;

    public RestMockServiceOptionsAction() {
        super("Options", "Sets options for this MockService");
    }

    @Override
    public void perform(RestMockService mockService, Object param) {
        if (mockService.getMockRunner() != null && mockService.getMockRunner().isRunning()) {
            UISupport.showErrorMessage("Can not set MockService options while running");
            return;
        }
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(OptionsForm.class);
        }
        this.dialog.setValue("Path", mockService.getPath());
        this.dialog.setValue("Host", mockService.getHost());
        this.dialog.setIntValue("Port", mockService.getPort());
        this.dialog.setValue("Docroot", mockService.getDocroot());
        if (this.dialog.show()) {
            mockService.setPath(this.dialog.getValue("Path"));
            mockService.setPort(this.dialog.getIntValue("Port", mockService.getPort()));
            mockService.setHost(this.dialog.getValue("Host"));
            mockService.setDocroot(this.dialog.getValue("Docroot"));
        }
    }

    @AForm(name="REST MockService Options", description="Set options for this REST mock service", helpUrl="/REST-Service-Mocking/mock-service-options.html", icon="/preferences-system.png")
    private class OptionsForm {
        @AField(name="Path", description="The path this MockService will mount on")
        public static final String PATH = "Path";
        @AField(name="Port", description="The port this MockService will mount on", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(name="Host", description="The local host to bind to and use in Port endpoints")
        public static final String HOST = "Host";
        @AField(name="Host Only", description="Only binds to specified host", type=AField.AFieldType.BOOLEAN)
        public static final String HOSTONLY = "Host Only";
        @AField(name="Docroot", description="The document root to serve (empty = none)", type=AField.AFieldType.FOLDER)
        public static final String DOCROOT = "Docroot";

        private OptionsForm() {
        }
    }
}

