/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.RestResourceConfig;
import com.eviware.soapui.config.RestServiceConfig;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestResourceContainer;
import com.eviware.soapui.impl.rest.panels.request.inspectors.schema.InferredSchemaManager;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wadl.WadlDefinitionContext;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.support.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;

public class RestService
extends AbstractInterface<RestServiceConfig>
implements RestResourceContainer {
    private List<RestResource> resources = new ArrayList<RestResource>();
    private WadlDefinitionContext wadlContext;
    private boolean exportChanges = false;

    public RestService(WsdlProject project, RestServiceConfig serviceConfig) {
        super(serviceConfig, project, "/rest_service.png");
        for (RestResourceConfig resourceConfig : serviceConfig.getResourceList()) {
            this.resources.add(new RestResource(this, resourceConfig));
        }
        if (!serviceConfig.isSetWadlVersion()) {
            serviceConfig.setWadlVersion(serviceConfig.isSetDefinitionUrl() ? "http://research.sun.com/wadl/2006/10" : "http://wadl.dev.java.net/2009/02");
        }
    }

    public String getWadlVersion() {
        return ((RestServiceConfig)this.getConfig()).getWadlVersion();
    }

    @Override
    public String getInterfaceType() {
        return "rest";
    }

    @Override
    public RestResource getOperationAt(int index) {
        return this.resources.get(index);
    }

    @Override
    public RestResource getOperationByName(String name) {
        return (RestResource)this.getWsdlModelItemByName(this.resources, name);
    }

    @Override
    public int getOperationCount() {
        return this.resources.size();
    }

    @Override
    public List<Operation> getOperationList() {
        return new ArrayList<Operation>(this.resources);
    }

    public String getBasePath() {
        return ((RestServiceConfig)this.getConfig()).isSetBasePath() ? ((RestServiceConfig)this.getConfig()).getBasePath() : "";
    }

    public void setBasePath(String basePath) {
        String old = this.getBasePath();
        ((RestServiceConfig)this.getConfig()).setBasePath(basePath);
        this.notifyPropertyChanged("basePath", old, basePath);
    }

    public String getInferredSchema() {
        return ((RestServiceConfig)this.getConfig()).getInferredSchema();
    }

    public void setInferredSchema(String inferredSchema) {
        String old = this.getInferredSchema();
        ((RestServiceConfig)this.getConfig()).setInferredSchema(inferredSchema);
        this.notifyPropertyChanged("inferredSchema", old, inferredSchema);
    }

    public boolean isGenerated() {
        return StringUtils.isNullOrEmpty(((RestServiceConfig)this.getConfig()).getDefinitionUrl());
    }

    public String getWadlUrl() {
        return this.isGenerated() ? this.generateWadlUrl() : ((RestServiceConfig)this.getConfig()).getDefinitionUrl();
    }

    public String generateWadlUrl() {
        return this.getName() + ".wadl";
    }

    public void setWadlUrl(String wadlUrl) {
        String old = this.getWadlUrl();
        ((RestServiceConfig)this.getConfig()).setDefinitionUrl(wadlUrl);
        this.notifyPropertyChanged("wadlUrl", old, wadlUrl);
    }

    @Override
    public String getTechnicalId() {
        return ((RestServiceConfig)this.getConfig()).getBasePath();
    }

    public RestResource addNewResource(String name, String path) {
        RestResourceConfig resourceConfig = ((RestServiceConfig)this.getConfig()).addNewResource();
        resourceConfig.setName(name);
        resourceConfig.setPath(path);
        RestResource resource = new RestResource(this, resourceConfig);
        this.resources.add(resource);
        this.fireOperationAdded(resource);
        return resource;
    }

    @Override
    public RestResource cloneResource(RestResource resource, String name) {
        RestResourceConfig resourceConfig = (RestResourceConfig)((RestServiceConfig)this.getConfig()).addNewResource().set((XmlObject)resource.getConfig());
        resourceConfig.setName(name);
        RestResource newResource = new RestResource(this, resourceConfig);
        this.resources.add(newResource);
        this.fireOperationAdded(newResource);
        return newResource;
    }

    @Override
    public void deleteResource(RestResource resource) {
        resource.deleteAllChildResources(resource);
        int ix = this.resources.indexOf(resource);
        if (!this.resources.remove(resource)) {
            return;
        }
        this.fireOperationRemoved(resource);
        ((RestServiceConfig)this.getConfig()).removeResource(ix);
        resource.release();
    }

    public List<RestResource> getAllResources() {
        ArrayList<RestResource> result = new ArrayList<RestResource>();
        for (RestResource resource : this.resources) {
            this.addResourcesToResult(resource, result);
        }
        return result;
    }

    public Map<String, RestResource> getResources() {
        HashMap<String, RestResource> result = new HashMap<String, RestResource>();
        for (RestResource resource : this.getAllResources()) {
            result.put(resource.getFullPath(false), resource);
        }
        return result;
    }

    private void addResourcesToResult(RestResource resource, List<RestResource> result) {
        result.add(resource);
        for (RestResource res : resource.getChildResourceList()) {
            this.addResourcesToResult(res, result);
        }
    }

    public RestResource getResourceByFullPath(String resourcePath) {
        for (RestResource resource : this.getAllResources()) {
            if (!resource.getFullPath().equals(resourcePath)) continue;
            return resource;
        }
        return null;
    }

    public RestResource[] getResourcesByFullPath(String resourcePath) {
        ArrayList<RestResource> result = new ArrayList<RestResource>();
        for (RestResource resource : this.getAllResources()) {
            if (!resource.getFullPath().equals(resourcePath)) continue;
            result.add(resource);
        }
        return result.toArray(new RestResource[result.size()]);
    }

    @Override
    public WadlDefinitionContext getDefinitionContext() {
        return this.getWadlContext();
    }

    public WadlDefinitionContext getWadlContext() {
        if (this.wadlContext == null) {
            this.wadlContext = new WadlDefinitionContext(this.getWadlUrl(), this);
        }
        return this.wadlContext;
    }

    @Override
    public String getDefinition() {
        return this.getWadlUrl();
    }

    @Override
    public String getType() {
        return "rest";
    }

    @Override
    public boolean isDefinitionShareble() {
        return !this.isGenerated();
    }

    @Override
    public Operation[] getAllOperations() {
        List<RestResource> restResources = this.getAllResources();
        return restResources.toArray(new Operation[restResources.size()]);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.isGenerated() && this.wadlContext != null) {
            try {
                this.wadlContext.getDefinitionCache().clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void release() {
        InferredSchemaManager.release(this);
        super.release();
    }

    public List<RestResource> getResourceList() {
        return new ArrayList<RestResource>(this.resources);
    }

    public boolean exportChanges() {
        return this.exportChanges;
    }

    public void setExportChanges(boolean exportChanges) {
        this.exportChanges = exportChanges;
    }
}

