/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.config.OAuth1ProfileConfig;
import com.eviware.soapui.config.OAuth1ProfileContainerConfig;
import com.eviware.soapui.impl.rest.OAuth1Profile;
import com.eviware.soapui.impl.rest.OAuth1ProfileListener;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.ObjectUtils;

public class OAuth1ProfileContainer {
    private final WsdlProject project;
    private final OAuth1ProfileContainerConfig configuration;
    private List<OAuth1Profile> OAuth1ProfileList = new ArrayList<OAuth1Profile>();
    private List<OAuth1ProfileListener> listeners = new CopyOnWriteArrayList<OAuth1ProfileListener>();

    public OAuth1ProfileContainer(WsdlProject project, OAuth1ProfileContainerConfig configuration) {
        this.project = project;
        this.configuration = configuration;
        this.buildOAuth1ProfileList();
    }

    public WsdlProject getProject() {
        return this.project;
    }

    public List<OAuth1Profile> getOAuth1ProfileList() {
        return this.OAuth1ProfileList;
    }

    public ArrayList<String> getOAuth1ProfileNameList() {
        ArrayList<String> profileNameList = new ArrayList<String>();
        for (OAuth1Profile profile : this.getOAuth1ProfileList()) {
            profileNameList.add(profile.getName());
        }
        return profileNameList;
    }

    public OAuth1Profile getProfileByName(String profileName) {
        for (OAuth1Profile profile : this.getOAuth1ProfileList()) {
            if (!profile.getName().equals(profileName)) continue;
            return profile;
        }
        return null;
    }

    public void renameProfile(String profileOldName, String newName) {
        this.getProfileByName(profileOldName).setName(newName);
        this.updateProfileForAllRequests(profileOldName, newName);
        this.fireOAuth1ProfileRenamed(profileOldName, newName);
    }

    public OAuth1Profile addNewOAuth1Profile(String profileName) {
        OAuth1ProfileConfig profileConfig = this.configuration.addNewOAuth1Profile();
        profileConfig.setName(profileName);
        OAuth1Profile OAuth1Profile2 = new OAuth1Profile(this, profileConfig);
        this.buildOAuth1ProfileList();
        this.fireOAuth1ProfileAdded(OAuth1Profile2);
        return OAuth1Profile2;
    }

    public void removeProfile(final String profileName) {
        for (int count = 0; count < this.configuration.sizeOfOAuth1ProfileArray(); ++count) {
            if (!this.configuration.getOAuth1ProfileArray(count).getName().equals(profileName)) continue;
            this.configuration.removeOAuth1Profile(count);
            break;
        }
        this.buildOAuth1ProfileList();
        this.doForAllRestRequests(new RestRequestCallback(){

            @Override
            public void doit(RestRequest restRequest) {
                if (ObjectUtils.equals((Object)restRequest.getSelectedAuthProfile(), (Object)profileName)) {
                    restRequest.setSelectedAuthProfileAndAuthType(CredentialsConfig.AuthType.NO_AUTHORIZATION.toString(), CredentialsConfig.AuthType.NO_AUTHORIZATION);
                }
            }
        });
        this.fireOAuth1ProfileRemoved(profileName);
    }

    public OAuth1ProfileContainerConfig getConfig() {
        return this.configuration;
    }

    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.project, this);
        for (OAuth1Profile OAuth1Profile2 : this.OAuth1ProfileList) {
            result.addAll(OAuth1Profile2.getPropertyExpansions());
        }
        return result.toArray();
    }

    private void buildOAuth1ProfileList() {
        this.OAuth1ProfileList.clear();
        for (OAuth1ProfileConfig profileConfig : this.configuration.getOAuth1ProfileList()) {
            this.OAuth1ProfileList.add(new OAuth1Profile(this, profileConfig));
        }
    }

    private void updateProfileForAllRequests(final String profileOldName, final String newName) {
        this.doForAllRestRequests(new RestRequestCallback(){

            @Override
            public void doit(RestRequest restRequest) {
                if (ObjectUtils.equals((Object)restRequest.getSelectedAuthProfile(), (Object)profileOldName)) {
                    restRequest.setSelectedAuthProfileAndAuthType(newName, CredentialsConfig.AuthType.Enum.forString(restRequest.getAuthType()));
                }
            }
        });
    }

    private void doForAllRestRequests(RestRequestCallback callback) {
        for (Interface iface : this.project.getInterfaceList()) {
            if (!(iface instanceof RestService)) continue;
            for (RestResource restResource : ((RestService)iface).getAllResources()) {
                for (RestMethod restMethod : restResource.getRestMethodList()) {
                    for (RestRequest restRequest : restMethod.getRequestList()) {
                        callback.doit(restRequest);
                    }
                }
            }
        }
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                for (RestTestRequestStep restTestRequestStep : testCase.getTestStepsOfType(RestTestRequestStep.class)) {
                    callback.doit(restTestRequestStep.getTestRequest());
                }
            }
        }
    }

    public void addOAuth1ProfileListener(OAuth1ProfileListener listener) {
        this.listeners.add(listener);
    }

    public void removeOAuth1ProfileListener(OAuth1ProfileListener listener) {
        this.listeners.remove(listener);
    }

    private void fireOAuth1ProfileAdded(OAuth1Profile OAuth1Profile2) {
        for (OAuth1ProfileListener listener : this.listeners) {
            listener.profileAdded(OAuth1Profile2);
        }
    }

    private void fireOAuth1ProfileRenamed(String profileOldName, String newName) {
        for (OAuth1ProfileListener listener : this.listeners) {
            listener.profileRenamed(profileOldName, newName);
        }
    }

    private void fireOAuth1ProfileRemoved(String profileName) {
        for (OAuth1ProfileListener listener : this.listeners) {
            listener.profileRemoved(profileName);
        }
    }

    private static interface RestRequestCallback {
        public void doit(RestRequest var1);
    }
}

