/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.config.OAuth2ProfileConfig;
import com.eviware.soapui.config.OAuth2ProfileContainerConfig;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.OAuth2ProfileContainer;
import com.eviware.soapui.impl.rest.OAuth2ProfileListener;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.ObjectUtils;

public class DefaultOAuth2ProfileContainer
implements OAuth2ProfileContainer {
    private final WsdlProject project;
    private final OAuth2ProfileContainerConfig configuration;
    private List<OAuth2Profile> oAuth2ProfileList = new ArrayList<OAuth2Profile>();
    private List<OAuth2ProfileListener> listeners = new CopyOnWriteArrayList<OAuth2ProfileListener>();

    public DefaultOAuth2ProfileContainer(WsdlProject project, OAuth2ProfileContainerConfig configuration) {
        this.project = project;
        this.configuration = configuration;
        this.buildOAuth2ProfileList();
    }

    @Override
    public WsdlProject getProject() {
        return this.project;
    }

    @Override
    public List<OAuth2Profile> getOAuth2ProfileList() {
        return this.oAuth2ProfileList;
    }

    @Override
    public ArrayList<String> getOAuth2ProfileNameList() {
        ArrayList<String> profileNameList = new ArrayList<String>();
        for (OAuth2Profile profile : this.getOAuth2ProfileList()) {
            profileNameList.add(profile.getName());
        }
        return profileNameList;
    }

    @Override
    public OAuth2Profile getProfileByName(String profileName) {
        for (OAuth2Profile profile : this.getOAuth2ProfileList()) {
            if (!profile.getName().equals(profileName)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public void renameProfile(String profileOldName, String newName) {
        this.getProfileByName(profileOldName).setName(newName);
        this.updateProfileForAllRequests(profileOldName, newName);
        this.fireOAuth2ProfileRenamed(profileOldName, newName);
    }

    @Override
    public void release() {
    }

    @Override
    public OAuth2Profile addNewOAuth2Profile(String profileName) {
        OAuth2ProfileConfig profileConfig = this.configuration.addNewOAuth2Profile();
        profileConfig.setName(profileName);
        OAuth2Profile oAuth2Profile = new OAuth2Profile(this, profileConfig);
        this.buildOAuth2ProfileList();
        this.fireOAuth2ProfileAdded(oAuth2Profile);
        return oAuth2Profile;
    }

    @Override
    public void removeProfile(final String profileName) {
        for (int count = 0; count < this.configuration.sizeOfOAuth2ProfileArray(); ++count) {
            if (!this.configuration.getOAuth2ProfileArray(count).getName().equals(profileName)) continue;
            this.configuration.removeOAuth2Profile(count);
            break;
        }
        this.buildOAuth2ProfileList();
        this.doForAllRestRequests(new RestRequestCallback(){

            @Override
            public void doit(RestRequest restRequest) {
                if (ObjectUtils.equals((Object)restRequest.getSelectedAuthProfile(), (Object)profileName)) {
                    restRequest.setSelectedAuthProfileAndAuthType(CredentialsConfig.AuthType.NO_AUTHORIZATION.toString(), CredentialsConfig.AuthType.NO_AUTHORIZATION);
                }
            }
        });
        this.fireOAuth2ProfileRemoved(profileName);
    }

    @Override
    public OAuth2ProfileContainerConfig getConfig() {
        return this.configuration;
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this.project, this);
        for (OAuth2Profile oAuth2Profile : this.oAuth2ProfileList) {
            result.addAll(oAuth2Profile.getPropertyExpansions());
        }
        return result.toArray();
    }

    private void buildOAuth2ProfileList() {
        this.oAuth2ProfileList.clear();
        for (OAuth2ProfileConfig profileConfig : this.configuration.getOAuth2ProfileList()) {
            this.oAuth2ProfileList.add(new OAuth2Profile(this, profileConfig));
        }
    }

    private void updateProfileForAllRequests(final String profileOldName, final String newName) {
        this.doForAllRestRequests(new RestRequestCallback(){

            @Override
            public void doit(RestRequest restRequest) {
                if (ObjectUtils.equals((Object)restRequest.getSelectedAuthProfile(), (Object)profileOldName)) {
                    restRequest.setSelectedAuthProfileAndAuthType(newName, CredentialsConfig.AuthType.Enum.forString(restRequest.getAuthType()));
                }
            }
        });
    }

    private void doForAllRestRequests(RestRequestCallback callback) {
        for (Interface iface : this.project.getInterfaceList()) {
            if (!(iface instanceof RestService)) continue;
            for (RestResource restResource : ((RestService)iface).getAllResources()) {
                for (RestMethod restMethod : restResource.getRestMethodList()) {
                    for (RestRequest restRequest : restMethod.getRequestList()) {
                        callback.doit(restRequest);
                    }
                }
            }
        }
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                for (RestTestRequestStep restTestRequestStep : testCase.getTestStepsOfType(RestTestRequestStep.class)) {
                    callback.doit(restTestRequestStep.getTestRequest());
                }
            }
        }
    }

    @Override
    public void addOAuth2ProfileListener(OAuth2ProfileListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeOAuth2ProfileListener(OAuth2ProfileListener listener) {
        this.listeners.remove(listener);
    }

    private void fireOAuth2ProfileAdded(OAuth2Profile oAuth2Profile) {
        for (OAuth2ProfileListener listener : this.listeners) {
            listener.profileAdded(oAuth2Profile);
        }
    }

    private void fireOAuth2ProfileRenamed(String profileOldName, String newName) {
        for (OAuth2ProfileListener listener : this.listeners) {
            listener.profileRenamed(profileOldName, newName);
        }
    }

    private void fireOAuth2ProfileRemoved(String profileName) {
        for (OAuth2ProfileListener listener : this.listeners) {
            listener.profileRemoved(profileName);
        }
    }

    private static interface RestRequestCallback {
        public void doit(RestRequest var1);
    }
}

