/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions.multi;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIMultiAction;
import java.util.HashSet;

public class MultiAssertionDeleteAction
extends AbstractSoapUIMultiAction<ModelItem> {
    public static final String SOAPUI_ACTION_ID = "MultiAssertionDeleteAction";

    public MultiAssertionDeleteAction() {
        super(SOAPUI_ACTION_ID, "Delete Assertions", "Delete selected Assertions");
    }

    @Override
    public void perform(ModelItem[] targets, Object param) {
        if (UISupport.confirm("Delete selected Assertions?", "Delete Assertions")) {
            if (SoapUI.getTestMonitor().hasRunningTestCase((TestCase)targets[0].getParent().getParent())) {
                UISupport.showInfoMessage("Can not remove assertion(s) while test case is running");
                return;
            }
            HashSet<TestAssertion> assertions = new HashSet<TestAssertion>();
            for (ModelItem target : targets) {
                assertions.add((TestAssertion)target);
            }
            for (TestAssertion assertion : assertions) {
                ((Assertable)((Object)assertion.getParent())).removeAssertion(assertion);
            }
        }
    }

    @Override
    public boolean applies(ModelItem target) {
        return target instanceof TestAssertion;
    }
}

