/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ProxyPrefs
implements Prefs {
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String USERNAME = "Username";
    public static final String PASSWORD = "Password";
    public static final String EXCLUDES = "Excludes";
    private JTextField hostTextField;
    private JTextField portTextField;
    private JTextField userTextField;
    private JPasswordField passwordTextField;
    private JTextField excludesTextField;
    private SimpleForm proxyPrefForm;
    private final String title;
    private JRadioButton automatic;
    private JRadioButton none;
    private JRadioButton manual;
    private boolean autoProxy;

    public ProxyPrefs(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public SimpleForm getForm() {
        if (this.proxyPrefForm == null) {
            this.proxyPrefForm = new SimpleForm();
            this.proxyPrefForm.addSpace(5);
            this.addProxySettingRadioButtons();
            this.hostTextField = this.proxyPrefForm.appendTextField(HOST, "proxy host to use");
            this.portTextField = this.proxyPrefForm.appendTextField(PORT, "proxy port to use");
            this.excludesTextField = this.proxyPrefForm.appendTextField(EXCLUDES, "Comma-seperated list of hosts to exclude");
            this.proxyPrefForm.appendSeparator();
            this.userTextField = this.proxyPrefForm.appendTextField(USERNAME, "proxy username to use");
            this.passwordTextField = this.proxyPrefForm.appendPasswordField(PASSWORD, "proxy password to use");
        }
        return this.proxyPrefForm;
    }

    private void addProxySettingRadioButtons() {
        ButtonGroup group = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        radioPanel.add(Box.createVerticalStrut(4));
        this.automatic = this.createRadioButton("Automatic", group, radioPanel);
        this.none = this.createRadioButton("None", group, radioPanel);
        this.manual = this.createRadioButton("Manual", group, radioPanel);
        this.proxyPrefForm.append("Proxy Setting", radioPanel);
        this.automatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyPrefs.this.autoProxy = true;
                ProxyPrefs.this.setManualProxyTextFieldsEnabled(true, false);
            }
        });
        this.manual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyPrefs.this.autoProxy = false;
                ProxyPrefs.this.setManualProxyTextFieldsEnabled(true, true);
            }
        });
        this.none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyPrefs.this.setManualProxyTextFieldsEnabled(false, false);
            }
        });
    }

    private JRadioButton createRadioButton(String text, ButtonGroup group, JPanel radioPanel) {
        JRadioButton radioButton = new JRadioButton(text);
        radioButton.setBorder(null);
        group.add(radioButton);
        radioPanel.add(radioButton);
        return radioButton;
    }

    private void setManualProxyTextFieldsEnabled(boolean userPasswordEnabled, boolean otherFieldsEnabled) {
        this.hostTextField.setEnabled(otherFieldsEnabled);
        this.portTextField.setEnabled(otherFieldsEnabled);
        this.userTextField.setEnabled(userPasswordEnabled);
        this.passwordTextField.setEnabled(userPasswordEnabled);
        this.excludesTextField.setEnabled(otherFieldsEnabled);
    }

    @Override
    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.proxyPrefForm.getValues(values);
        this.storeValues(values, settings);
    }

    @Override
    public StringToStringMap getValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        values.put(HOST, settings.getString(ProxySettings.HOST, ""));
        values.put(PORT, settings.getString(ProxySettings.PORT, ""));
        values.put(USERNAME, settings.getString(ProxySettings.USERNAME, ""));
        values.put(PASSWORD, settings.getString(ProxySettings.PASSWORD, ""));
        values.put(EXCLUDES, settings.getString(ProxySettings.EXCLUDES, ""));
        return values;
    }

    @Override
    public void setFormValues(Settings settings) {
        this.getForm().setValues(this.getValues(settings));
        if (!settings.getBoolean(ProxySettings.ENABLE_PROXY)) {
            this.none.setSelected(true);
            this.setManualProxyTextFieldsEnabled(false, false);
        } else if (settings.getBoolean(ProxySettings.AUTO_PROXY)) {
            this.automatic.setSelected(true);
            this.autoProxy = true;
            this.setManualProxyTextFieldsEnabled(true, false);
        } else {
            this.manual.setSelected(true);
            this.autoProxy = false;
            this.setManualProxyTextFieldsEnabled(true, true);
        }
        this.autoProxy = settings.getBoolean(ProxySettings.AUTO_PROXY);
    }

    @Override
    public void storeValues(StringToStringMap values, Settings settings) {
        boolean enableProxy;
        String proxyHost = (String)values.get(HOST);
        String proxyPort = (String)values.get(PORT);
        settings.setString(ProxySettings.HOST, proxyHost);
        settings.setString(ProxySettings.PORT, proxyPort);
        settings.setString(ProxySettings.USERNAME, (String)values.get(USERNAME));
        settings.setString(ProxySettings.PASSWORD, (String)values.get(PASSWORD));
        settings.setString(ProxySettings.EXCLUDES, (String)values.get(EXCLUDES));
        boolean bl = enableProxy = !this.none.isSelected();
        if (!this.autoProxy && (StringUtils.isNullOrEmpty(proxyHost) || StringUtils.isNullOrEmpty(proxyPort))) {
            enableProxy = false;
        }
        settings.setBoolean(ProxySettings.ENABLE_PROXY, enableProxy);
        settings.setBoolean(ProxySettings.AUTO_PROXY, this.autoProxy);
        SoapUI.updateProxyFromSettings();
    }
}

