/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10.entrytypes;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.test.validator.ValidatorException;
import org.wsi.test.validator.bsp10.SecureConstants;
import org.wsi.test.validator.bsp10.entrytypes.SecureEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SecurityHeaderEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SigReferenceEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SignedInfoEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SoapEnvelopeEntryType;
import org.wsi.test.validator.bsp10.entrytypes.SoapHeaderEntryType;

public class SignatureEntryType
extends SecureEntryType {
    private static Factory fInstance = new Factory();

    public static Factory getFactory() {
        return fInstance;
    }

    private SignatureEntryType(Element element) {
        super(element);
    }

    public String getEntryTypeTag() {
        return "signature";
    }

    public Element getSignedInfo() throws ValidatorException {
        NodeList nodeList = this.getElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            if (!SignedInfoEntryType.getFactory().isValidElement(element)) continue;
            return element;
        }
        throw new ValidatorException("SIGNATURE has no SIGNED_INFO child");
    }

    private boolean sameSiblingPosition(Node node, Node node2) {
        int n = 0;
        Node node3 = node;
        while (node3 != null) {
            node3 = node3.getPreviousSibling();
            ++n;
        }
        int n2 = 0;
        node3 = node2;
        while (node3 != null) {
            node3 = node3.getPreviousSibling();
            ++n2;
        }
        return n == n2;
    }

    public boolean isEnvelopingSignature() throws ValidatorException {
        SignedInfoEntryType signedInfoEntryType = (SignedInfoEntryType)SignedInfoEntryType.getFactory().newInstance(this.getSignedInfo());
        Element[] elementArray = signedInfoEntryType.getReferences();
        for (int i = 0; i < elementArray.length; ++i) {
            Node node;
            Node node2;
            Element element;
            SigReferenceEntryType sigReferenceEntryType = (SigReferenceEntryType)SigReferenceEntryType.getFactory().newInstance(elementArray[i]);
            Element element2 = sigReferenceEntryType.itemReferenced();
            if (element2 == null) continue;
            Element element3 = null;
            Node node3 = element2.getParentNode();
            while (node3.getNodeType() == 1 && element3 == null) {
                if (SignatureEntryType.getFactory().isValidElement((Element)node3)) {
                    element3 = (Element)node3;
                }
                node3 = node3.getParentNode();
            }
            if (element3 == null || !this.sameSiblingPosition(element = this.getElement(), element3) || !this.sameSiblingPosition(node2 = element.getParentNode(), node = element3.getParentNode())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnvelopedSignature() throws ValidatorException {
        SignedInfoEntryType signedInfoEntryType = (SignedInfoEntryType)SignedInfoEntryType.getFactory().newInstance(this.getSignedInfo());
        Element[] elementArray = signedInfoEntryType.getReferences();
        for (int i = 0; i < elementArray.length; ++i) {
            SigReferenceEntryType sigReferenceEntryType = (SigReferenceEntryType)SigReferenceEntryType.getFactory().newInstance(elementArray[i]);
            Element element = sigReferenceEntryType.itemReferenced();
            if (element == null) continue;
            if (SecurityHeaderEntryType.getFactory().isValidElement(element)) {
                if (!this.sameSiblingPosition(element, this.getElement().getParentNode())) continue;
                return true;
            }
            if (SoapHeaderEntryType.getFactory().isValidElement(element)) {
                return true;
            }
            if (!SoapEnvelopeEntryType.getFactory().isValidElement(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isDetachedSignature() throws ValidatorException {
        return !this.isEnvelopedSignature() && !this.isEnvelopingSignature();
    }

    public static class Factory
    extends SecureEntryType.Factory {
        private Factory() {
        }

        public SecureEntryType newInstance(Element element) {
            return new SignatureEntryType(element);
        }

        public boolean isValidElement(Element element) {
            if (!this.checkURIandName(element, SecureConstants.DS_NAMESPACE, "Signature")) {
                return false;
            }
            Element element2 = (Element)element.getParentNode();
            return SecurityHeaderEntryType.getFactory().isValidElement(element2);
        }
    }
}

