/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.validator.bsp10;

import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.wsi.test.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTestUtilities {
    public static Map<String, String> parseSchemaDateTime(String string) throws ValidatorException {
        ValidatorException validatorException = new ValidatorException("Invalid dateTime string");
        int n = 0;
        if (string.charAt(n) == '-') {
            ++n;
        }
        String string2 = "";
        while (Character.isDigit(string.charAt(n))) {
            string2 = string2 + string.charAt(n);
            ++n;
        }
        if (string.charAt(n) != '-') {
            throw validatorException;
        }
        String string3 = string.substring(++n, n + 2);
        if (string.charAt(n += 2) != '-') {
            throw validatorException;
        }
        String string4 = string.substring(++n, n + 2);
        SecurityTestUtilities.validateDateTimeDate(string2, string3, string4);
        if (string.charAt(n += 2) != 'T') {
            throw validatorException;
        }
        String string5 = string.substring(++n, n + 2);
        if (string.charAt(n += 2) != ':') {
            throw validatorException;
        }
        String string6 = string.substring(++n, n + 2);
        if (string.charAt(n += 2) != ':') {
            throw validatorException;
        }
        String string7 = string.substring(++n, n + 2);
        SecurityTestUtilities.validateDateTimeTime(string5, string6, string7);
        String string8 = null;
        if (string.charAt(n += 2) == '.') {
            ++n;
            string8 = "";
            while (Character.isDigit(string.charAt(n))) {
                string8 = string8 + string.charAt(n);
                ++n;
            }
        }
        String string9 = string.substring(n);
        SecurityTestUtilities.validateDateTimeTimezone(string9);
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("seconds", string7);
        hashMap.put("fractionalSeconds", string8);
        hashMap.put("timezone", string9);
        return hashMap;
    }

    private static void validateDateTimeDate(String string, String string2, String string3) throws ValidatorException {
        String string4;
        String string5 = string4 = string.charAt(0) == '-' ? string.substring(1) : string;
        if (string4.equals("0000")) {
            throw new ValidatorException("DateTime parsing error:  0000 not allowed as year in DateTime");
        }
        if (string4.length() > 4 && string4.charAt(0) == '0') {
            throw new ValidatorException("DateTime parsing error:  Leading zeros not allowed in a year that is more than four digits");
        }
        int n = Integer.valueOf(string4);
        if (string2.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Month must be two digits");
        }
        int n2 = Integer.valueOf(string2);
        if (n2 < 1 || n2 > 12) {
            throw new ValidatorException("DateTime parsing error:  Illegal month value");
        }
        if (string3.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Date must be two digits");
        }
        int n3 = Integer.valueOf(string3);
        if (n3 < 1 || n3 > 31) {
            throw new ValidatorException("DateTime parsing error:  Illegal date value");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, n3);
        gregorianCalendar.setLenient(false);
        try {
            gregorianCalendar.getTime();
        }
        catch (Throwable throwable) {
            throw new ValidatorException("DateTime parsing error:  Illegal day specified");
        }
    }

    private static void validateDateTimeTime(String string, String string2, String string3) throws ValidatorException {
        if (string.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Hour must be two digits");
        }
        int n = Integer.valueOf(string);
        if (n < 0 || n > 24) {
            throw new ValidatorException("DateTime parsing error:  Illegal hour value");
        }
        if (string2.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Minute must be two digits");
        }
        int n2 = Integer.valueOf(string2);
        if (n2 < 0 || n2 > 59) {
            throw new ValidatorException("DateTime parsing error:  Illegal minute value");
        }
        if (string3.length() != 2) {
            throw new ValidatorException("DateTime parsing error:  Second must be two digits");
        }
        int n3 = Integer.valueOf(string3);
        if (n3 < 0 || n3 > 60) {
            throw new ValidatorException("DateTime parsing error:  Illegal second value");
        }
        if (n == 24 && n2 != 0 && n3 != 0) {
            throw new ValidatorException("DateTime parsing error:  Illegal time value");
        }
    }

    private static void validateDateTimeTimezone(String string) {
    }

    public static void main(String[] stringArray) {
        try {
            SecurityTestUtilities.parseSchemaDateTime("2002-02-30T12:00:00-05:00");
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
        System.out.println("done");
    }
}

