/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.LinkedList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.store.raw.log.LogAccessFileBuffer;
import org.apache.derby.io.StorageRandomAccessFile;

public class LogAccessFile
extends OutputStream {
    private static final int LOG_RECORD_FIXED_OVERHEAD_SIZE = 16;
    private static final int LOG_NUMBER_LOG_BUFFERS = 3;
    private LinkedList freeBuffers;
    private LinkedList dirtyBuffers;
    private LogAccessFileBuffer currentBuffer;
    private boolean flushInProgress = false;
    private final StorageRandomAccessFile log;
    private final Object logFileSemaphore;
    static int mon_numWritesToLog;
    static int mon_numBytesToLog;

    public LogAccessFile(StorageRandomAccessFile storageRandomAccessFile, int n) throws IOException {
        this.log = storageRandomAccessFile;
        this.logFileSemaphore = storageRandomAccessFile;
        this.freeBuffers = new LinkedList();
        this.dirtyBuffers = new LinkedList();
        for (int i = 0; i < 3; ++i) {
            LogAccessFileBuffer logAccessFileBuffer = new LogAccessFileBuffer(n);
            this.freeBuffers.addLast(logAccessFileBuffer);
        }
        this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
    }

    public void writeLogRecord(int n, long l, byte[] byArray, int n2, byte[] byArray2, int n3, int n4) throws StandardException, IOException {
        int n5 = n + 16;
        if (n5 > this.currentBuffer.bytes_free && n5 <= this.currentBuffer.buffer.length) {
            this.switchLogBuffer();
        }
        if (n5 <= this.currentBuffer.bytes_free) {
            byte[] byArray3 = this.currentBuffer.buffer;
            int n6 = this.currentBuffer.position;
            byArray3[n6++] = (byte)(n >>> 24 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 16 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 8 & 0xFF);
            byArray3[n6++] = (byte)(n & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 56) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 48) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 40) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 32) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 24) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 16) & 0xFF);
            byArray3[n6++] = (byte)((int)(l >>> 8) & 0xFF);
            byArray3[n6++] = (byte)((int)l & 0xFF);
            int n7 = n - n4;
            System.arraycopy(byArray, n2, byArray3, n6, n7);
            n6 += n7;
            if (n4 != 0) {
                System.arraycopy(byArray2, n3, byArray3, n6, n4);
                n6 += n4;
            }
            byArray3[n6++] = (byte)(n >>> 24 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 16 & 0xFF);
            byArray3[n6++] = (byte)(n >>> 8 & 0xFF);
            byArray3[n6++] = (byte)(n & 0xFF);
            this.currentBuffer.position = n6;
            this.currentBuffer.bytes_free -= n5;
        } else {
            this.writeInt(n);
            this.writeLong(l);
            this.write(byArray, n2, n - n4);
            if (n4 != 0) {
                this.write(byArray2, n3, n4);
            }
            this.writeInt(n);
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.currentBuffer.bytes_free < 4) {
            this.switchLogBuffer();
        }
        byte[] byArray = this.currentBuffer.buffer;
        int n2 = this.currentBuffer.position;
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        this.currentBuffer.position = n2;
        this.currentBuffer.bytes_free -= 4;
    }

    public void writeLong(long l) throws IOException {
        if (this.currentBuffer.bytes_free < 8) {
            this.switchLogBuffer();
        }
        byte[] byArray = this.currentBuffer.buffer;
        int n = this.currentBuffer.position;
        byArray[n++] = (byte)((int)(l >>> 56) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 48) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 40) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 32) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 24) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 16) & 0xFF);
        byArray[n++] = (byte)((int)(l >>> 8) & 0xFF);
        byArray[n++] = (byte)((int)l & 0xFF);
        this.currentBuffer.position = n;
        this.currentBuffer.bytes_free -= 8;
    }

    public void write(int n) throws IOException {
        if (this.currentBuffer.bytes_free == 0) {
            this.switchLogBuffer();
        }
        this.currentBuffer.buffer[this.currentBuffer.position++] = (byte)n;
        --this.currentBuffer.bytes_free;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= this.currentBuffer.bytes_free) {
            System.arraycopy(byArray, n, this.currentBuffer.buffer, this.currentBuffer.position, n2);
            this.currentBuffer.bytes_free -= n2;
            this.currentBuffer.position += n2;
            return;
        }
        if (n2 <= this.currentBuffer.buffer.length) {
            System.arraycopy(byArray, n, this.currentBuffer.buffer, this.currentBuffer.position, this.currentBuffer.bytes_free);
            this.currentBuffer.position += this.currentBuffer.bytes_free;
            this.currentBuffer.bytes_free = 0;
            this.switchLogBuffer();
            System.arraycopy(byArray, n += this.currentBuffer.bytes_free, this.currentBuffer.buffer, 0, n2 -= this.currentBuffer.bytes_free);
            this.currentBuffer.position = n2;
            this.currentBuffer.bytes_free -= n2;
        } else {
            this.flushLogAccessFile();
            this.writeToLog(byArray, n, n2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushDirtyBuffers() throws IOException {
        LogAccessFile logAccessFile;
        LogAccessFileBuffer logAccessFileBuffer = null;
        int n = 0;
        try {
            int n2;
            LogAccessFile logAccessFile2 = this;
            synchronized (logAccessFile2) {
                while (this.flushInProgress) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                n2 = this.dirtyBuffers.size();
                if (n2 > 0) {
                    logAccessFileBuffer = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                }
                this.flushInProgress = true;
            }
            while (n < n2) {
                if (logAccessFileBuffer.position != 0) {
                    this.writeToLog(logAccessFileBuffer.buffer, 0, logAccessFileBuffer.position);
                }
                ++n;
                logAccessFile2 = this;
                synchronized (logAccessFile2) {
                    this.freeBuffers.addLast(logAccessFileBuffer);
                    if (n < n2) {
                        logAccessFileBuffer = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                    } else {
                        int n3 = this.dirtyBuffers.size();
                        if (n3 > 0 && n <= 3) {
                            n2 += n3;
                            logAccessFileBuffer = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                        }
                    }
                }
            }
            Object var9_9 = null;
            logAccessFile = this;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            LogAccessFile logAccessFile3 = this;
            synchronized (logAccessFile3) {
                this.flushInProgress = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (logAccessFile) {
            this.flushInProgress = false;
            this.notifyAll();
        }
    }

    public void flushLogAccessFile() throws IOException {
        this.switchLogBuffer();
        this.flushDirtyBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogBuffer() throws IOException {
        LogAccessFile logAccessFile = this;
        synchronized (logAccessFile) {
            this.dirtyBuffers.addLast(this.currentBuffer);
            if (this.freeBuffers.size() == 0) {
                this.flushDirtyBuffers();
            }
            this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
            this.currentBuffer.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLogAccessFile() throws IOException, StandardException {
        int n = 0;
        while (true) {
            try {
                LogAccessFile logAccessFile = this;
                synchronized (logAccessFile) {
                    this.log.sync(false);
                }
            }
            catch (SyncFailedException syncFailedException) {
                ++n;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= 20) continue;
                throw StandardException.newException("XSLA4.D", syncFailedException, null);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corrupt() throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.flushLogAccessFile();
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLog(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                int n3 = 0;
                while (true) {
                    try {
                        this.log.write(byArray, n, n2);
                    }
                    catch (IOException iOException) {
                        if (n3 >= 5) {
                            throw iOException;
                        }
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

