/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;

class GenericAggregator {
    AggregatorInfo aggInfo;
    int aggregatorColumnId;
    private int inputColumnId;
    private int resultColumnId;
    private ResultDescription inputColumnResultDescription;
    private ExecRow[] rowArray;
    private TemporaryRowHolderResultSet execResultSet;
    private final ClassFactory cf;
    private ExecAggregator cachedAggregator;

    GenericAggregator(AggregatorInfo aggregatorInfo, ClassFactory classFactory) {
        this.aggInfo = aggregatorInfo;
        this.aggregatorColumnId = aggregatorInfo.getAggregatorColNum();
        this.inputColumnId = aggregatorInfo.getInputColNum();
        this.resultColumnId = aggregatorInfo.getOutputColNum();
        int[] nArray = new int[1];
        this.inputColumnResultDescription = aggregatorInfo.getResultDescription();
        this.cf = classFactory;
    }

    void initialize(ExecRow execRow) throws StandardException {
        UserDataValue userDataValue = (UserDataValue)execRow.getColumn(this.aggregatorColumnId + 1);
        ExecAggregator execAggregator = (ExecAggregator)userDataValue.getObject();
        if (execAggregator == null) {
            execAggregator = this.getAggregatorInstance();
            userDataValue.setValue(execAggregator);
        }
    }

    void accumulate(ExecRow execRow, ExecRow execRow2) throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        DataValueDescriptor dataValueDescriptor2 = execRow2.getColumn(this.aggregatorColumnId + 1);
        dataValueDescriptor = execRow.getColumn(this.inputColumnId + 1);
        this.accumulate(dataValueDescriptor, dataValueDescriptor2);
    }

    void accumulate(Object[] objectArray, Object[] objectArray2) throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        DataValueDescriptor dataValueDescriptor2 = (DataValueDescriptor)objectArray2[this.aggregatorColumnId];
        dataValueDescriptor = (DataValueDescriptor)objectArray[this.inputColumnId];
        this.accumulate(dataValueDescriptor, dataValueDescriptor2);
    }

    void accumulate(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        ExecAggregator execAggregator = (ExecAggregator)dataValueDescriptor2.getObject();
        if (execAggregator == null) {
            execAggregator = this.getAggregatorInstance();
        }
        execAggregator.accumulate(dataValueDescriptor, this);
    }

    void merge(ExecRow execRow, ExecRow execRow2) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow2.getColumn(this.aggregatorColumnId + 1);
        DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(this.aggregatorColumnId + 1);
        this.merge(dataValueDescriptor2, dataValueDescriptor);
    }

    void merge(Object[] objectArray, Object[] objectArray2) throws StandardException {
        DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)objectArray2[this.aggregatorColumnId];
        DataValueDescriptor dataValueDescriptor2 = (DataValueDescriptor)objectArray[this.aggregatorColumnId];
        this.merge(dataValueDescriptor2, dataValueDescriptor);
    }

    boolean finish(ExecRow execRow) throws StandardException {
        Object object;
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.resultColumnId + 1);
        DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(this.aggregatorColumnId + 1);
        ExecAggregator execAggregator = (ExecAggregator)dataValueDescriptor2.getObject();
        if (execAggregator == null) {
            execAggregator = this.getAggregatorInstance();
        }
        if ((object = execAggregator.getResult()) == null) {
            dataValueDescriptor.setToNull();
        } else if (object instanceof DataValueDescriptor) {
            execRow.setColumn(this.resultColumnId + 1, (DataValueDescriptor)object);
        } else {
            dataValueDescriptor.setValue(object);
        }
        return execAggregator.didEliminateNulls();
    }

    ExecAggregator getAggregatorInstance() throws StandardException {
        ExecAggregator execAggregator;
        if (this.cachedAggregator == null) {
            try {
                Class clazz = this.cf.loadApplicationClass(this.aggInfo.getAggregatorClassName());
                Object t = clazz.newInstance();
                this.cachedAggregator = execAggregator = (ExecAggregator)t;
                execAggregator.setup(this.aggInfo.getAggregateName());
            }
            catch (Exception exception) {
                throw StandardException.unexpectedUserException(exception);
            }
        } else {
            execAggregator = this.cachedAggregator.newAggregator();
        }
        return execAggregator;
    }

    int getColumnId() {
        return this.aggregatorColumnId;
    }

    void merge(Storable storable, Storable storable2) throws StandardException {
        ExecAggregator execAggregator = (ExecAggregator)((UserDataValue)storable).getObject();
        ExecAggregator execAggregator2 = (ExecAggregator)((UserDataValue)storable2).getObject();
        execAggregator2.merge(execAggregator);
    }

    AggregatorInfo getAggregatorInfo() {
        return this.aggInfo;
    }
}

