/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropSPSConstantAction
extends DDLConstantAction {
    private final String spsName;
    private final SchemaDescriptor sd;

    DropSPSConstantAction(SchemaDescriptor schemaDescriptor, String string) {
        this.sd = schemaDescriptor;
        this.spsName = string;
    }

    public String toString() {
        String string = "???";
        if (this.sd != null) {
            string = this.sd.getSchemaName();
        }
        return "DROP STATEMENT " + string + "." + this.spsName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        dataDictionary.startWriting(languageConnectionContext);
        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(this.spsName, this.sd);
        if (sPSDescriptor == null) {
            throw StandardException.newException("X0X81.S", "STATEMENT", (Object)(this.sd.getSchemaName() + "." + this.spsName));
        }
        dependencyManager.invalidateFor(sPSDescriptor, 13, languageConnectionContext);
        sPSDescriptor.makeInvalid(13, languageConnectionContext);
        dataDictionary.dropSPSDescriptor(sPSDescriptor, languageConnectionContext.getTransactionExecute());
    }
}

