/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public class UserTypeConstantNode
extends ConstantNode {
    Object value;

    public void init(Object object) throws StandardException {
        DataValueDescriptor dataValueDescriptor = null;
        if (object instanceof TypeId) {
            super.init(object, Boolean.TRUE, ReuseFactory.getInteger(-1));
        } else {
            Integer n = null;
            TypeId typeId = null;
            if (object instanceof DataValueDescriptor) {
                dataValueDescriptor = (DataValueDescriptor)object;
            }
            if (object instanceof Date || dataValueDescriptor != null && dataValueDescriptor.getTypeFormatId() == 298) {
                n = ReuseFactory.getInteger(4);
                typeId = TypeId.getBuiltInTypeId(91);
            } else if (object instanceof Time || dataValueDescriptor != null && dataValueDescriptor.getTypeFormatId() == 299) {
                n = ReuseFactory.getInteger(8);
                typeId = TypeId.getBuiltInTypeId(92);
            } else if (object instanceof Timestamp || dataValueDescriptor != null && dataValueDescriptor.getTypeFormatId() == 31) {
                n = ReuseFactory.getInteger(12);
                typeId = TypeId.getBuiltInTypeId(93);
            }
            super.init(typeId, object == null ? Boolean.TRUE : Boolean.FALSE, n);
            if (dataValueDescriptor != null) {
                this.setValue(dataValueDescriptor);
            } else if (object instanceof Date) {
                this.setValue(this.getDataValueFactory().getDataValue((Date)object));
            } else if (object instanceof Time) {
                this.setValue(this.getDataValueFactory().getDataValue((Time)object));
            } else if (object instanceof Timestamp) {
                this.setValue(this.getDataValueFactory().getDataValue((Timestamp)object));
            }
            this.value = object;
        }
    }

    public Object getObjectValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public DataValueDescriptor getStorableValue() throws StandardException {
        if (this.value instanceof DataValueDescriptor) {
            return ((DataValueDescriptor)this.value).getClone();
        }
        DataValueFactory dataValueFactory = this.getDataValueFactory();
        TypeId typeId = this.getTypeId();
        String string = typeId.getSQLTypeName();
        if (string.equals("DATE")) {
            return new SQLDate((Date)this.value);
        }
        if (string.equals("TIME")) {
            return new SQLTime((Time)this.value);
        }
        if (string.equals("TIMESTAMP")) {
            return new SQLTimestamp((Timestamp)this.value);
        }
        return dataValueFactory.getDataValue(this.value, (UserDataValue)null);
    }

    public void setObjectValue(Object object) {
        this.value = object;
    }

    public Object getConstantValueAsObject() {
        return this.value;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        TypeCompiler typeCompiler = this.getTypeCompiler();
        String string = typeCompiler.interfaceName();
        if (this.value == null) {
            expressionClassBuilder.generateNull(methodBuilder, typeCompiler);
        } else {
            String string2 = this.getTypeId().getCorrespondingJavaTypeName();
            methodBuilder.push(this.value.toString());
            methodBuilder.callMethod((short)184, string2, "valueOf", string2, 1);
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            expressionClassBuilder.generateDataValue(methodBuilder, typeCompiler, localField);
        }
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }
}

