/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Locale;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CurrentUserNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ColumnDefinitionNode
extends TableElementNode {
    boolean isAutoincrement;
    DataTypeDescriptor dataTypeServices;
    DataValueDescriptor defaultValue;
    DefaultInfoImpl defaultInfo;
    DefaultNode defaultNode;
    long autoincrementIncrement;
    long autoincrementStart;
    boolean autoincrementVerify;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object);
        this.dataTypeServices = (DataTypeDescriptor)object3;
        if (object2 instanceof UntypedNullConstantNode) {
            if (object3 != null) {
                this.defaultValue = ((UntypedNullConstantNode)object2).convertDefaultNode(this.dataTypeServices);
            }
        } else {
            this.defaultNode = (DefaultNode)object2;
            if (object4 != null) {
                long[] lArray = (long[])object4;
                this.autoincrementStart = lArray[0];
                this.autoincrementIncrement = lArray[1];
                this.autoincrementVerify = lArray[2] <= 0L;
                this.isAutoincrement = true;
                if (object3 != null) {
                    this.dataTypeServices.setNullability(false);
                }
            }
        }
    }

    public String toString() {
        return "";
    }

    public String getColumnName() {
        return this.name;
    }

    public DataTypeDescriptor getDataTypeServices() {
        return this.dataTypeServices;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public DefaultInfo getDefaultInfo() {
        return this.defaultInfo;
    }

    public DefaultNode getDefaultNode() {
        return this.defaultNode;
    }

    public boolean isAutoincrementColumn() {
        return this.isAutoincrement;
    }

    long getAutoincrementStart() {
        return this.autoincrementStart;
    }

    long getAutoincrementIncrement() {
        return this.autoincrementIncrement;
    }

    public void checkUserType(TableDescriptor tableDescriptor) throws StandardException {
        if (this.dataTypeServices.getTypeId().builtIn()) {
            return;
        }
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String string = this.dataTypeServices.getTypeId().getCorrespondingJavaTypeName();
        boolean bl = false;
        Throwable throwable = null;
        try {
            bl = classInspector.accessible(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        if (!bl) {
            throw StandardException.newException("42X26", throwable, (Object)string, (Object)this.name);
        }
        if (!classInspector.assignableTo(string, "java.io.Serializable") && !classInspector.assignableTo(string, "java.sql.SQLData")) {
            this.getCompilerContext().addWarning(StandardException.newWarning("01J04", string, this.name));
        }
    }

    UUID getOldDefaultUUID() {
        return null;
    }

    int getAction() {
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (tableDescriptor != null && !this.dataTypeServices.isNullable() && this.defaultNode == null && !this.isAutoincrement) {
            throw StandardException.newException("42601", this.getColumnName());
        }
        if (this.defaultNode == null) {
            return;
        }
        if (this.defaultValue != null) {
            return;
        }
        this.validateDefault(dataDictionary, tableDescriptor);
    }

    public void validateAutoincrement(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int n) throws StandardException {
        if (!this.isAutoincrement) {
            return;
        }
        if (n == 3) {
            throw StandardException.newException("42995");
        }
        if (this.autoincrementIncrement == 0L) {
            throw StandardException.newException("42Z21", this.getColumnName());
        }
        int n2 = this.dataTypeServices.getTypeId().getJDBCTypeId();
        switch (n2) {
            case -6: {
                this.autoincrementCheckRange(-128L, 127L, "TINYINT");
                break;
            }
            case 5: {
                this.autoincrementCheckRange(-32768L, 32767L, "SMALLINT");
                break;
            }
            case 4: {
                this.autoincrementCheckRange(Integer.MIN_VALUE, Integer.MAX_VALUE, "INTEGER");
                break;
            }
            case -5: {
                this.autoincrementCheckRange(Long.MIN_VALUE, Long.MAX_VALUE, "BIGINT");
                break;
            }
            default: {
                throw StandardException.newException("42Z22", this.getColumnName());
            }
        }
    }

    private void autoincrementCheckRange(long l, long l2, String string) throws StandardException {
        if (l > this.autoincrementIncrement || l2 < this.autoincrementIncrement) {
            throw StandardException.newException("22003", string);
        }
        if (l > this.autoincrementStart || l2 < this.autoincrementStart) {
            throw StandardException.newException("22003", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateDefault(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (this.defaultNode == null) {
            return;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        ValueNode valueNode = this.defaultNode.getDefaultTree();
        int n = compilerContext.getReliability();
        try {
            ProviderList providerList = new ProviderList();
            ProviderList providerList2 = compilerContext.getCurrentAuxiliaryProviderList();
            compilerContext.setCurrentAuxiliaryProviderList(providerList);
            compilerContext.setReliability(1192);
            valueNode = valueNode.bindExpression((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
            TypeId typeId = this.dataTypeServices.getTypeId();
            TypeId typeId2 = valueNode.getTypeId();
            if (!this.defaultTypeIsValid(typeId, this.dataTypeServices, typeId2, valueNode, this.defaultNode.getDefaultText())) {
                throw StandardException.newException("42894", this.name);
            }
            if (!this.getTypeCompiler(typeId).storable(typeId2, this.getClassFactory())) {
                throw StandardException.newException("42821", typeId.getSQLTypeName(), (Object)typeId2.getSQLTypeName());
            }
            this.defaultInfo = new DefaultInfoImpl(this.defaultNode.getDefaultText(), this.defaultValue);
            if (providerList.size() > 0) {
                this.defaultNode.setAuxiliaryProviderList(providerList);
                ProviderInfo[] providerInfoArray = null;
                DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
                this.defaultInfo.setProviderInfo(providerInfoArray);
            }
            compilerContext.setCurrentAuxiliaryProviderList(providerList2);
        }
        finally {
            compilerContext.setReliability(n);
        }
    }

    public boolean defaultTypeIsValid(TypeId typeId, DataTypeDescriptor dataTypeDescriptor, TypeId typeId2, ValueNode valueNode, String string) {
        int n;
        if (string.length() > 254) {
            return false;
        }
        int n2 = typeId.getTypeFormatId();
        int n3 = n = typeId2 == null ? -1 : typeId2.getTypeFormatId();
        if (!valueNode.isConstantExpression()) {
            boolean bl;
            boolean bl2 = bl = n2 == 5 || n2 == 13 || n2 == 230;
            if (valueNode instanceof CurrentUserNode) {
                if ((string = string.toLowerCase(Locale.ENGLISH)).indexOf("user") != -1) {
                    return bl && dataTypeDescriptor.getMaximumWidth() >= 8;
                }
                if (string.indexOf("schema") != -1 || string.indexOf("sqlid") != -1) {
                    return bl && dataTypeDescriptor.getMaximumWidth() >= 128;
                }
                return false;
            }
        }
        switch (n2) {
            case 7: {
                return n == 7;
            }
            case 11: {
                return n == 7 || n == 11;
            }
            case 197: {
                if (n == 197) {
                    DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
                    int n4 = string.length();
                    int n5 = dataTypeDescriptor2.getPrecision();
                    int n6 = dataTypeDescriptor2.getScale();
                    int n7 = 1;
                    while (n7 <= n6 && string.charAt(n4 - n7) == '0') {
                        --n6;
                        --n5;
                    }
                    return n6 <= dataTypeDescriptor.getScale() && n5 - n6 <= dataTypeDescriptor.getPrecision() - dataTypeDescriptor.getScale();
                }
                return n == 11 || n == 7;
            }
            case 5: 
            case 13: 
            case 230: {
                return n == 5;
            }
            case 27: 
            case 29: 
            case 232: {
                return n == 27;
            }
            case 267: {
                return n == n2;
            }
            case 6: 
            case 8: 
            case 10: 
            case 35: 
            case 36: 
            case 40: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }
}

