/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSTABLESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSTABLES";
    protected static final int SYSTABLES_COLUMN_COUNT = 5;
    protected static final int SYSTABLES_TABLEID = 1;
    protected static final int SYSTABLES_TABLENAME = 2;
    protected static final int SYSTABLES_TABLETYPE = 3;
    protected static final int SYSTABLES_SCHEMAID = 4;
    protected static final int SYSTABLES_LOCKGRANULARITY = 5;
    protected static final int SYSTABLES_INDEX1_ID = 0;
    protected static final int SYSTABLES_INDEX1_TABLENAME = 1;
    protected static final int SYSTABLES_INDEX1_SCHEMAID = 2;
    protected static final int SYSTABLES_INDEX2_ID = 1;
    protected static final int SYSTABLES_INDEX2_TABLEID = 1;
    private static final String[] uuids = new String[]{"80000018-00d0-fd77-3ed8-000a0a0b1900", "80000028-00d0-fd77-3ed8-000a0a0b1900", "8000001a-00d0-fd77-3ed8-000a0a0b1900", "8000001c-00d0-fd77-3ed8-000a0a0b1900"};
    private static final int[][] indexColumnPositions = new int[][]{{2, 4}, {1}};
    private static final String[][] indexColumnNames = new String[][]{{"TABLENAME", "SCHEMAID"}, {"TABLEID"}};

    public SYSTABLESRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(5, TABLENAME_STRING, indexColumnPositions, indexColumnNames, null, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (tupleDescriptor != null) {
            TableDescriptor tableDescriptor = (TableDescriptor)tupleDescriptor;
            SchemaDescriptor schemaDescriptor = (SchemaDescriptor)tupleDescriptor2;
            UUID uUID = tableDescriptor.getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                tableDescriptor.setUUID(uUID);
            }
            string3 = uUID.toString();
            string4 = schemaDescriptor.getUUID().toString();
            string5 = tableDescriptor.getName();
            int n = tableDescriptor.getTableType();
            switch (n) {
                case 0: {
                    string = "T";
                    break;
                }
                case 1: {
                    string = "S";
                    break;
                }
                case 2: {
                    string = "V";
                    break;
                }
            }
            char[] cArray = new char[]{tableDescriptor.getLockGranularity()};
            string2 = new String(cArray);
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(5);
        execRow.setColumn(1, this.dvf.getCharDataValue(string3));
        execRow.setColumn(2, this.dvf.getVarcharDataValue(string5));
        execRow.setColumn(3, this.dvf.getCharDataValue(string));
        execRow.setColumn(4, this.dvf.getCharDataValue(string4));
        execRow.setColumn(5, this.dvf.getCharDataValue(string2));
        return execRow;
    }

    public ExecIndexRow buildEmptyIndexRow(int n, RowLocation rowLocation) throws StandardException {
        int n2 = this.getIndexColumnCount(n);
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(n2 + 1);
        execIndexRow.setColumn(n2 + 1, rowLocation);
        switch (n) {
            case 0: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getVarcharDataValue(null));
                execIndexRow.setColumn(2, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            case 1: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
            }
        }
        return execIndexRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        int n;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        String string3 = dataValueDescriptor.getString();
        switch (string3.charAt(0)) {
            case 'T': {
                n = 0;
                break;
            }
            case 'S': {
                n = 1;
                break;
            }
            case 'V': {
                n = 2;
                break;
            }
            default: {
                n = -1;
            }
        }
        dataValueDescriptor = execRow.getColumn(4);
        String string4 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string4);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID2, null);
        dataValueDescriptor = execRow.getColumn(5);
        String string5 = dataValueDescriptor.getString();
        TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(string2, schemaDescriptor, n, string5.charAt(0));
        tableDescriptor.setUUID(uUID);
        return tableDescriptor;
    }

    protected String getTableName(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(2);
        return dataValueDescriptor.getString();
    }

    public SystemColumn[] buildColumnList() {
        SystemColumn[] systemColumnArray = new SystemColumn[]{new SystemColumnImpl(this.convertIdCase("TABLEID"), 1, 0, 0, false, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("TABLENAME"), 2, false), new SystemColumnImpl(this.convertIdCase("TABLETYPE"), 3, 0, 0, false, "CHAR", true, 1), new SystemColumnImpl(this.convertIdCase("SCHEMAID"), 4, 0, 0, false, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("LOCKGRANULARITY"), 5, 0, 0, false, "CHAR", true, 1)};
        return systemColumnArray;
    }
}

