/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.LoadError;

class ExportResultSetForObject {
    private Connection con;
    private String entityName;
    private String selectStatement;
    private ResultSet rs;
    private int columnCount;
    private String[] columnNames;
    private String[] columnTypes;
    private int[] columnLengths;
    private Statement expStmt = null;

    public ExportResultSetForObject(Connection connection, String string, String string2, String string3) {
        this.con = connection;
        if (string3 == null) {
            this.entityName = string == null ? string2 : string + "." + string2;
        }
        this.selectStatement = string3;
    }

    public ResultSet getResultSet() throws Exception {
        this.rs = null;
        String string = this.getQuery();
        Statement statement = this.con.createStatement();
        this.rs = statement.executeQuery(string);
        this.getMetaDataInfo();
        return this.rs;
    }

    public String getQuery() {
        if (this.selectStatement != null) {
            return this.selectStatement;
        }
        this.selectStatement = "select * from " + this.entityName;
        return this.selectStatement;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String[] getColumnDefinition() {
        return this.columnNames;
    }

    public String[] getColumnTypes() {
        return this.columnTypes;
    }

    public int[] getColumnLengths() {
        return this.columnLengths;
    }

    private void getMetaDataInfo() throws Exception {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = this.columnCount = resultSetMetaData.getColumnCount();
        this.columnNames = new String[n];
        this.columnTypes = new String[n];
        this.columnLengths = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = resultSetMetaData.getColumnType(i + 1);
            this.columnNames[i] = resultSetMetaData.getColumnName(i + 1);
            this.columnTypes[i] = resultSetMetaData.getColumnTypeName(i + 1);
            if (!ColumnInfo.importExportSupportedType(n2)) {
                throw LoadError.nonSupportedTypeColumn(this.columnNames[i], this.columnTypes[i]);
            }
            this.columnLengths[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
        }
    }

    public void close() throws Exception {
        if (this.expStmt != null) {
            this.expStmt.close();
        }
    }
}

