/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;

public class EmbedParameterSetMetaData {
    private final ParameterValueSet pvs;
    private final DataTypeDescriptor[] types;
    private final int paramCount;

    protected EmbedParameterSetMetaData(ParameterValueSet parameterValueSet, DataTypeDescriptor[] dataTypeDescriptorArray) {
        int n;
        if (parameterValueSet.isUsingParameterValueSet()) {
            parameterValueSet = null;
            dataTypeDescriptorArray = null;
            n = 0;
        } else {
            n = parameterValueSet.getParameterCount();
        }
        this.pvs = parameterValueSet;
        this.paramCount = n;
        this.types = dataTypeDescriptorArray;
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public int isNullable(int n) throws SQLException {
        this.checkPosition(n);
        if (this.types[n - 1].isNullable()) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().isNumericTypeId();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkPosition(n);
        int n2 = -1;
        int n3 = DataTypeUtilities.getPrecision(this.types[n - 1]);
        if (n == 1 && this.pvs.hasReturnOutputParameter()) {
            n2 = this.pvs.getPrecision(n);
        }
        return n2 == -1 ? n3 : n2;
    }

    public int getScale(int n) throws SQLException {
        this.checkPosition(n);
        if (n == 1 && this.pvs.hasReturnOutputParameter()) {
            return this.pvs.getScale(n);
        }
        return this.types[n - 1].getScale();
    }

    public int getParameterType(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().getJDBCTypeId();
    }

    public String getParameterTypeName(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().getSQLTypeName();
    }

    public String getParameterClassName(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().getResultSetMetaDataTypeName();
    }

    public int getParameterMode(int n) throws SQLException {
        this.checkPosition(n);
        if (n == 1 && this.pvs.hasReturnOutputParameter()) {
            return 4;
        }
        return this.pvs.getParameterMode(n);
    }

    private void checkPosition(int n) throws SQLException {
        if (n < 1 || n > this.paramCount) {
            throw Util.generateCsSQLException("XCL13.S", (Object)new Integer(n), new Integer(this.paramCount));
        }
    }
}

