/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.types.SQLBlob;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongVarbit;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLNClob;
import org.apache.derby.iapi.types.SQLNationalChar;
import org.apache.derby.iapi.types.SQLNationalLongvarchar;
import org.apache.derby.iapi.types.SQLNationalVarchar;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.UserType;

public class DataValueFactoryImpl
implements DataValueFactory {
    LocaleFinder localeFinder;

    public DataValueFactoryImpl(LocaleFinder localeFinder) {
        this.localeFinder = localeFinder;
    }

    public NumberDataValue getDataValue(int n) {
        return new SQLInteger(n);
    }

    public NumberDataValue getDataValue(int n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLInteger(n);
        }
        numberDataValue.setValue(n);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Integer n) {
        if (n != null) {
            return new SQLInteger((int)n);
        }
        return new SQLInteger();
    }

    public NumberDataValue getDataValue(Integer n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(n);
        }
        numberDataValue.setValue(n);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(char c) {
        return new SQLInteger(c);
    }

    public NumberDataValue getDataValue(char c, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLInteger(c);
        }
        numberDataValue.setValue(c);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(short s) {
        return new SQLSmallint(s);
    }

    public NumberDataValue getDataValue(short s, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLSmallint(s);
        }
        numberDataValue.setValue(s);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Short s) {
        if (s != null) {
            return new SQLSmallint(s);
        }
        return new SQLSmallint();
    }

    public NumberDataValue getDataValue(Short s, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(s);
        }
        numberDataValue.setValue(s);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(byte by) {
        return new SQLTinyint(by);
    }

    public NumberDataValue getDataValue(byte by, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLTinyint(by);
        }
        numberDataValue.setValue(by);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Byte by) {
        if (by != null) {
            return new SQLTinyint(by);
        }
        return new SQLTinyint();
    }

    public NumberDataValue getDataValue(Byte by, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(by);
        }
        numberDataValue.setValue(by);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(long l) {
        return new SQLLongint(l);
    }

    public NumberDataValue getDataValue(long l, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLLongint(l);
        }
        numberDataValue.setValue(l);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Long l) {
        if (l != null) {
            return new SQLLongint((long)l);
        }
        return new SQLLongint();
    }

    public NumberDataValue getDataValue(Long l, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(l);
        }
        numberDataValue.setValue(l);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(float f) throws StandardException {
        return new SQLReal(f);
    }

    public NumberDataValue getDataValue(float f, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLReal(f);
        }
        numberDataValue.setValue(f);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Float f) throws StandardException {
        if (f != null) {
            return new SQLReal(f.floatValue());
        }
        return new SQLReal();
    }

    public NumberDataValue getDataValue(Float f, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(f);
        }
        numberDataValue.setValue(f);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(double d) throws StandardException {
        return new SQLDouble(d);
    }

    public NumberDataValue getDataValue(double d, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return new SQLDouble(d);
        }
        numberDataValue.setValue(d);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(Double d) throws StandardException {
        if (d != null) {
            return new SQLDouble((double)d);
        }
        return new SQLDouble();
    }

    public NumberDataValue getDataValue(Double d, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(d);
        }
        numberDataValue.setValue(d);
        return numberDataValue;
    }

    public NumberDataValue getDataValue(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return new SQLDecimal(bigDecimal);
        }
        return new SQLDecimal();
    }

    public NumberDataValue getDataValue(BigDecimal bigDecimal, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDataValue(bigDecimal);
        }
        numberDataValue.setValue(bigDecimal);
        return numberDataValue;
    }

    public NumberDataValue getDecimalDataValue(String string) throws StandardException {
        if (string != null) {
            return new SQLDecimal(string);
        }
        return new SQLDecimal();
    }

    public NumberDataValue getDecimalDataValue(String string, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            return this.getDecimalDataValue(string);
        }
        numberDataValue.setValue(string);
        return numberDataValue;
    }

    public BooleanDataValue getDataValue(boolean bl) {
        return new SQLBoolean(bl);
    }

    public BooleanDataValue getDataValue(boolean bl, BooleanDataValue booleanDataValue) throws StandardException {
        if (booleanDataValue == null) {
            return new SQLBoolean(bl);
        }
        booleanDataValue.setValue(bl);
        return booleanDataValue;
    }

    public BooleanDataValue getDataValue(Boolean bl) {
        if (bl != null) {
            return new SQLBoolean((boolean)bl);
        }
        return new SQLBoolean();
    }

    public BooleanDataValue getDataValue(Boolean bl, BooleanDataValue booleanDataValue) throws StandardException {
        if (booleanDataValue == null) {
            return this.getDataValue(bl);
        }
        booleanDataValue.setValue(bl);
        return booleanDataValue;
    }

    public BooleanDataValue getDataValue(BooleanDataValue booleanDataValue) {
        if (booleanDataValue != null) {
            return booleanDataValue;
        }
        return new SQLBoolean();
    }

    public BitDataValue getBitDataValue(byte[] byArray) throws StandardException {
        return new SQLBit(byArray);
    }

    public BitDataValue getBitDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLBit(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getVarbitDataValue(byte[] byArray) {
        return new SQLVarbit(byArray);
    }

    public BitDataValue getVarbitDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLVarbit(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getLongVarbitDataValue(byte[] byArray) throws StandardException {
        return new SQLLongVarbit(byArray);
    }

    public BitDataValue getLongVarbitDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLLongVarbit(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public BitDataValue getBlobDataValue(byte[] byArray) throws StandardException {
        return new SQLBlob(byArray);
    }

    public BitDataValue getBlobDataValue(byte[] byArray, BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return new SQLBlob(byArray);
        }
        bitDataValue.setValue(byArray);
        return bitDataValue;
    }

    public StringDataValue getCharDataValue(String string) {
        return new SQLChar(string);
    }

    public StringDataValue getCharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLChar(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getVarcharDataValue(String string) {
        return new SQLVarchar(string);
    }

    public StringDataValue getVarcharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLVarchar(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getLongvarcharDataValue(String string) {
        return new SQLLongvarchar(string);
    }

    public StringDataValue getClobDataValue(String string) {
        return new SQLClob(string);
    }

    public StringDataValue getLongvarcharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLLongvarchar(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getClobDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLClob(string);
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getNationalCharDataValue(String string) {
        return new SQLNationalChar(string, this.getLocaleFinder());
    }

    public StringDataValue getNationalCharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLNationalChar(string, this.getLocaleFinder());
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getNationalVarcharDataValue(String string) {
        return new SQLNationalVarchar(string, this.getLocaleFinder());
    }

    public StringDataValue getNationalVarcharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLNationalVarchar(string, this.getLocaleFinder());
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getNationalLongvarcharDataValue(String string) {
        return new SQLNationalLongvarchar(string, this.getLocaleFinder());
    }

    public StringDataValue getNationalLongvarcharDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLNationalLongvarchar(string, this.getLocaleFinder());
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue getNClobDataValue(String string) {
        return new SQLNClob(string, this.getLocaleFinder());
    }

    public StringDataValue getNClobDataValue(String string, StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            return new SQLNClob(string, this.getLocaleFinder());
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public DateTimeDataValue getDataValue(Date date) throws StandardException {
        return new SQLDate(date);
    }

    public DateTimeDataValue getDataValue(Date date, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            return new SQLDate(date);
        }
        dateTimeDataValue.setValue(date);
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDataValue(Time time) throws StandardException {
        return new SQLTime(time);
    }

    public DateTimeDataValue getDataValue(Time time, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            return new SQLTime(time);
        }
        dateTimeDataValue.setValue(time);
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDataValue(Timestamp timestamp) throws StandardException {
        return new SQLTimestamp(timestamp);
    }

    public DateTimeDataValue getDataValue(Timestamp timestamp, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            return new SQLTimestamp(timestamp);
        }
        dateTimeDataValue.setValue(timestamp);
        return dateTimeDataValue;
    }

    public DateTimeDataValue getTimestamp(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return new SQLTimestamp(dataValueDescriptor, dataValueDescriptor2);
    }

    public UserDataValue getDataValue(Object object) {
        return new UserType(object);
    }

    public UserDataValue getDataValue(Object object, UserDataValue userDataValue) {
        if (userDataValue == null) {
            return new UserType(object);
        }
        ((UserType)userDataValue).setValue(object);
        return userDataValue;
    }

    public RefDataValue getDataValue(RowLocation rowLocation) {
        return new SQLRef(rowLocation);
    }

    public RefDataValue getDataValue(RowLocation rowLocation, RefDataValue refDataValue) {
        if (refDataValue == null) {
            return new SQLRef(rowLocation);
        }
        refDataValue.setValue(rowLocation);
        return refDataValue;
    }

    public NumberDataValue getNullInteger(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLInteger();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullShort(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLSmallint();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullLong(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLLongint();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullByte(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLTinyint();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullFloat(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLReal();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullDouble(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLDouble();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public NumberDataValue getNullBigDecimal(NumberDataValue numberDataValue) {
        if (numberDataValue == null) {
            return new SQLDecimal();
        }
        numberDataValue.setToNull();
        return numberDataValue;
    }

    public BooleanDataValue getNullBoolean(BooleanDataValue booleanDataValue) {
        if (booleanDataValue == null) {
            return new SQLBoolean();
        }
        booleanDataValue.setToNull();
        return booleanDataValue;
    }

    public BitDataValue getNullBit(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return this.getBitDataValue(null);
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public BitDataValue getNullVarbit(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return this.getVarbitDataValue(null);
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public BitDataValue getNullLongVarbit(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return this.getLongVarbitDataValue(null);
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public BitDataValue getNullBlob(BitDataValue bitDataValue) throws StandardException {
        if (bitDataValue == null) {
            return this.getBlobDataValue(null);
        }
        bitDataValue.setToNull();
        return bitDataValue;
    }

    public StringDataValue getNullChar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getCharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullVarchar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getVarcharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullLongvarchar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getLongvarcharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullClob(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getClobDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullNationalChar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getNationalCharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullNationalVarchar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getNationalVarcharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullNationalLongvarchar(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getNationalLongvarcharDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public StringDataValue getNullNClob(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            return this.getNClobDataValue(null);
        }
        stringDataValue.setToNull();
        return stringDataValue;
    }

    public UserDataValue getNullObject(UserDataValue userDataValue) {
        if (userDataValue == null) {
            return this.getDataValue((Object)null);
        }
        userDataValue.setToNull();
        return userDataValue;
    }

    public RefDataValue getNullRef(RefDataValue refDataValue) {
        if (refDataValue == null) {
            return this.getDataValue((RowLocation)null);
        }
        refDataValue.setToNull();
        return refDataValue;
    }

    public DateTimeDataValue getNullDate(DateTimeDataValue dateTimeDataValue) {
        if (dateTimeDataValue == null) {
            try {
                return this.getDataValue((Date)null);
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        dateTimeDataValue.setToNull();
        return dateTimeDataValue;
    }

    public DateTimeDataValue getNullTime(DateTimeDataValue dateTimeDataValue) {
        if (dateTimeDataValue == null) {
            try {
                return this.getDataValue((Time)null);
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        dateTimeDataValue.setToNull();
        return dateTimeDataValue;
    }

    public DateTimeDataValue getNullTimestamp(DateTimeDataValue dateTimeDataValue) {
        if (dateTimeDataValue == null) {
            try {
                return this.getDataValue((Timestamp)null);
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        dateTimeDataValue.setToNull();
        return dateTimeDataValue;
    }

    public DateTimeDataValue getDateValue(String string, boolean bl) throws StandardException {
        return new SQLDate(string, bl, this.getLocaleFinder());
    }

    public DateTimeDataValue getTimeValue(String string, boolean bl) throws StandardException {
        return new SQLTime(string, bl, this.getLocaleFinder());
    }

    public DateTimeDataValue getTimestampValue(String string, boolean bl) throws StandardException {
        return new SQLTimestamp(string, bl, this.getLocaleFinder());
    }

    private LocaleFinder getLocaleFinder() {
        DatabaseContext databaseContext;
        if (this.localeFinder == null && (databaseContext = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = databaseContext.getDatabase();
        }
        return this.localeFinder;
    }
}

