/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DataDictionaryContext;
import org.apache.derby.iapi.sql.dictionary.TabInfo;
import org.apache.derby.iapi.sql.execute.ExecRow;

public class RowList
extends Vector
implements Formatable {
    private String tableName;
    protected transient TabInfo tableInfo;

    public RowList() {
    }

    public RowList(TabInfo tabInfo) {
        this.tableInfo = tabInfo;
        this.tableName = tabInfo.getTableName();
    }

    public RowList(String string) {
        this.tableName = string;
    }

    public void add(ExecRow execRow) {
        super.addElement(execRow);
    }

    public String getTableName() throws StandardException {
        return this.getTableInfo().getTableName();
    }

    public long getTableID() throws StandardException {
        return this.getTableInfo().getHeapConglomerate();
    }

    public void deleteFromCatalog(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.getTableInfo().deleteRowList(this, languageConnectionContext);
    }

    public void stuffCatalog(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.getTableInfo().insertRowList(this, languageConnectionContext);
    }

    private TabInfo getTableInfo() throws StandardException {
        if (this.tableInfo == null) {
            DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)ContextService.getContext("DataDictionaryContext");
            DataDictionary dataDictionary = dataDictionaryContext.getDataDictionary();
            this.tableInfo = dataDictionary.getTabInfo(this.tableName);
        }
        return this.tableInfo;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.tableName = (String)objectInput.readObject();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            ExecRow execRow = (ExecRow)objectInput.readObject();
            this.add(execRow);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.tableName);
        int n = this.size();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(this.elementAt(i));
        }
    }

    public int getTypeFormatId() {
        return 239;
    }
}

