/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;

public final class AliasDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider {
    private UUID aliasID;
    private String aliasName;
    private UUID schemaID;
    private String javaClassName;
    private char aliasType;
    private char nameSpace;
    private boolean systemAlias;
    private AliasInfo aliasInfo;
    private String specificName;

    public AliasDescriptor(DataDictionary dataDictionary, UUID uUID, String string, UUID uUID2, String string2, char c, char c2, boolean bl, AliasInfo aliasInfo, String string3) {
        super(dataDictionary);
        this.aliasID = uUID;
        this.aliasName = string;
        this.schemaID = uUID2;
        this.javaClassName = string2;
        this.aliasType = c;
        this.nameSpace = c2;
        this.systemAlias = bl;
        this.aliasInfo = aliasInfo;
        if (string3 == null) {
            string3 = dataDictionary.getSystemSQLName();
        }
        this.specificName = string3;
    }

    public UUID getUUID() {
        return this.aliasID;
    }

    public UUID getSchemaUUID() {
        return this.schemaID;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public char getNameSpace() {
        return this.nameSpace;
    }

    public boolean getSystemAlias() {
        return this.systemAlias;
    }

    public AliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public String toString() {
        return "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof AliasDescriptor)) {
            return false;
        }
        AliasDescriptor aliasDescriptor = (AliasDescriptor)object;
        return this.aliasID.equals(aliasDescriptor.getUUID());
    }

    public int hashCode() {
        return this.aliasID.hashCode();
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(136);
    }

    public String getObjectName() {
        return this.aliasName;
    }

    public UUID getObjectID() {
        return this.aliasID;
    }

    public String getClassType() {
        return "Alias";
    }

    public String getDescriptorType() {
        switch (this.aliasType) {
            case 'P': {
                return "PROCEDURE";
            }
            case 'F': {
                return "FUNCTION";
            }
        }
        return null;
    }

    public String getDescriptorName() {
        return this.aliasName;
    }

    public String getSpecificName() {
        return this.specificName;
    }
}

