/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;

public class DRDAServerStarter
implements ModuleControl,
Runnable {
    private Object server;
    private Method serverStartMethod;
    private Method serverShutdownMethod;
    private boolean loadSysIBM;
    private Thread serverThread;
    private static final String serverClassName = "org.apache.derby.impl.drda.DB2jServerImpl";
    private Class serverClass;
    private InetAddress listenAddress = null;
    private int portNumber = -1;
    private PrintWriter consoleWriter = null;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$java$io$PrintWriter;

    public void setStartInfo(InetAddress inetAddress, int n, PrintWriter printWriter) {
        this.listenAddress = inetAddress;
        this.portNumber = n;
        this.consoleWriter = printWriter;
    }

    public void boot(boolean bl, Properties properties) {
        if (this.server != null) {
            return;
        }
        try {
            this.serverClass = Class.forName(serverClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Monitor.logTextMessage("J100", serverClassName);
            return;
        }
        catch (Error error) {
            Monitor.logTextMessage("J101", serverClassName, error.getMessage());
            return;
        }
        try {
            Constructor constructor;
            try {
                constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException, SecurityException {
                        if (DRDAServerStarter.this.listenAddress == null) {
                            return DRDAServerStarter.this.serverClass.getDeclaredConstructor(null);
                        }
                        return DRDAServerStarter.this.serverClass.getDeclaredConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = DRDAServerStarter.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE);
                    }
                });
                this.serverStartMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException, SecurityException {
                        return DRDAServerStarter.this.serverClass.getMethod("blockingStart", class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = DRDAServerStarter.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
                    }
                });
                this.serverShutdownMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException, SecurityException {
                        return DRDAServerStarter.this.serverClass.getMethod("directShutdown", null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                Monitor.logTextMessage("J102", exception.getMessage());
                privilegedActionException.printStackTrace(Monitor.getStream().getPrintWriter());
                return;
            }
            this.server = this.listenAddress == null ? constructor.newInstance(null) : constructor.newInstance(this.listenAddress, new Integer(this.portNumber));
            this.serverThread = Monitor.getMonitor().getDaemonThread(this, "NetworkServerStarter", false);
            this.serverThread.start();
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J102", exception.getMessage());
            this.server = null;
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    public void run() {
        try {
            this.serverStartMethod.invoke(this.server, this.consoleWriter);
        }
        catch (InvocationTargetException invocationTargetException) {
            Monitor.logTextMessage("J102", invocationTargetException.getTargetException().getMessage());
            invocationTargetException.printStackTrace(Monitor.getStream().getPrintWriter());
            this.server = null;
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J102", exception.getMessage());
            this.server = null;
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    public void stop() {
        try {
            if (this.serverThread != null && this.serverThread.isAlive()) {
                this.serverShutdownMethod.invoke(this.server, null);
                this.serverThread.interrupt();
                this.serverThread = null;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Monitor.logTextMessage("J103", invocationTargetException.getTargetException().getMessage());
            invocationTargetException.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        catch (Exception exception) {
            Monitor.logTextMessage("J103", exception.getMessage());
            exception.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        this.serverThread = null;
        this.server = null;
        this.serverClass = null;
        this.serverStartMethod = null;
        this.serverShutdownMethod = null;
        this.listenAddress = null;
        this.portNumber = -1;
        this.consoleWriter = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

