/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class DefaultInfoImpl
implements DefaultInfo,
Formatable {
    private DataValueDescriptor defaultValue;
    private String defaultText;
    private ProviderInfo[] providerInfo;

    public DefaultInfoImpl() {
    }

    public DefaultInfoImpl(String string, DataValueDescriptor dataValueDescriptor) {
        this.defaultText = string;
        this.defaultValue = dataValueDescriptor;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public String toString() {
        return this.defaultText;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.defaultText = (String)objectInput.readObject();
        this.defaultValue = (DataValueDescriptor)objectInput.readObject();
        int n = objectInput.readInt();
        if (n > 0) {
            this.providerInfo = new ProviderInfo[n];
            for (int i = 0; i < n; ++i) {
                this.providerInfo[i] = (ProviderInfo)objectInput.readObject();
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.defaultText);
        objectOutput.writeObject(this.defaultValue);
        if (this.providerInfo != null) {
            objectOutput.writeInt(this.providerInfo.length);
            for (int i = 0; i < this.providerInfo.length; ++i) {
                objectOutput.writeObject(this.providerInfo[i]);
            }
        } else {
            objectOutput.writeInt(0);
        }
    }

    public int getTypeFormatId() {
        return 326;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataValueDescriptor dataValueDescriptor) {
        this.defaultValue = dataValueDescriptor;
    }

    public void setProviderInfo(ProviderInfo[] providerInfoArray) {
        this.providerInfo = providerInfoArray;
    }

    public ProviderInfo[] getProviderInfo() {
        return this.providerInfo;
    }
}

