/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.derby.iapi.db.ConsistencyChecker;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.PropertyInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.load.Export;
import org.apache.derby.impl.load.Import;
import org.apache.derby.impl.sql.execute.JarDDL;

public class SystemProcedures {
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;

    public static void SQLCAMESSAGE(int n, short s, String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, String string3, String string4, String string5, String string6, String[] stringArray, int[] nArray) {
        int n8 = 1;
        byte[] byArray = new byte[]{20, 20, 20};
        String string7 = new String(byArray);
        int n9 = 0;
        while (string.indexOf(string7, n9) != -1) {
            n9 = string.indexOf(string7, n9) + string7.length();
            ++n8;
        }
        if (n8 == 1) {
            MessageService.getLocalizedMessage(n, s, string, string2, n2, n3, n4, n5, n6, n7, string3, string4, string5, string6, stringArray, nArray);
        } else {
            n9 = 0;
            String[] stringArray2 = new String[2];
            for (int i = 0; i < n8; ++i) {
                int n10 = string.indexOf(string7, n9);
                String string8 = i == n8 - 1 ? string.substring(n9) : string.substring(n9, n10);
                if (i > 0) {
                    string4 = string8.substring(0, 5);
                    string8 = string8.substring(6);
                    stringArray[0] = stringArray[0] + " SQLSTATE: " + string4 + ": ";
                }
                MessageService.getLocalizedMessage(n, (short)string8.length(), string8, string2, n2, n3, n4, n5, n6, n7, string3, string4, string5, string6, stringArray2, nArray);
                if (nArray[0] == 0) {
                    stringArray[0] = i == 0 ? stringArray2[0] : stringArray[0] + stringArray2[0];
                }
                n9 = n10 + string7.length();
            }
        }
    }

    private static DatabaseMetaData getDMD() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        return connection.getMetaData();
    }

    public static void SQLPROCEDURES(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getProcedures(string, string2, string3);
    }

    public static void SQLTABLES(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        String string6 = SystemProcedures.getOption("GETCATALOGS", string5);
        if (string6 != null && string6.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getCatalogs();
            return;
        }
        string6 = SystemProcedures.getOption("GETTABLETYPES", string5);
        if (string6 != null && string6.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getTableTypes();
            return;
        }
        string6 = SystemProcedures.getOption("GETSCHEMAS", string5);
        if (string6 != null && string6.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getSchemas();
            return;
        }
        String[] stringArray = null;
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "',");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        resultSetArray[0] = SystemProcedures.getDMD().getTables(string, string2, string3, stringArray);
    }

    public static void SQLFOREIGNKEYS(String string, String string2, String string3, String string4, String string5, String string6, String string7, ResultSet[] resultSetArray) throws SQLException {
        String string8 = SystemProcedures.getOption("EXPORTEDKEY", string7);
        String string9 = SystemProcedures.getOption("IMPORTEDKEY", string7);
        resultSetArray[0] = string9 != null && string9.trim().equals("1") ? SystemProcedures.getDMD().getImportedKeys(string4, string5, string6) : (string8 != null && string8.trim().equals("1") ? SystemProcedures.getDMD().getExportedKeys(string, string2, string3) : SystemProcedures.getDMD().getCrossReference(string, string2, string3, string4, string5, string6));
    }

    private static String getOption(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(string);
        if (n < 0) {
            return null;
        }
        int n2 = string2.indexOf(61, n);
        if (n2 < 0) {
            return null;
        }
        int n3 = string2.indexOf(59, n2);
        if (n3 < 0) {
            return string2.substring(n2 + 1);
        }
        return string2.substring(n2 + 1, n3);
    }

    public static void SQLPROCEDURECOLS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getProcedureColumns(string, string2, string3, string4);
    }

    public static void SQLCOLUMNS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getColumns(string, string2, string3, string4);
    }

    public static void SQLCOLPRIVILEGES(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getColumnPrivileges(string, string2, string3, string4);
    }

    public static void SQLTABLEPRIVILEGES(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getTablePrivileges(string, string2, string3);
    }

    public static void SQLPRIMARYKEYS(String string, String string2, String string3, String string4, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getPrimaryKeys(string, string2, string3);
    }

    public static void SQLGETTYPEINFO(short s, String string, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getTypeInfo();
    }

    public static void SQLSTATISTICS(String string, String string2, String string3, short s, short s2, String string4, ResultSet[] resultSetArray) throws SQLException {
        boolean bl = s == 0;
        boolean bl2 = s2 == 1;
        resultSetArray[0] = SystemProcedures.getDMD().getIndexInfo(string, string2, string3, bl, bl2);
    }

    public static void SQLSPECIALCOLUMNS(short s, String string, String string2, String string3, short s2, short s3, String string4, ResultSet[] resultSetArray) throws SQLException {
        boolean bl = s3 == 1;
        resultSetArray[0] = s == 1 ? SystemProcedures.getDMD().getBestRowIdentifier(string, string2, string3, s2, bl) : SystemProcedures.getDMD().getVersionColumns(string, string2, string3);
    }

    public static void SQLUDTS(String string, String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        int[] nArray = null;
        if (string4 != null && string4.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t\n\t,");
            int n = stringTokenizer.countTokens();
            nArray = new int[n];
            String string6 = "";
            try {
                for (int i = 0; i < n; ++i) {
                    string6 = stringTokenizer.nextToken();
                    nArray[i] = Integer.parseInt(string6);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid type, " + string6 + ", passed to getUDTs.");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLException("Internal failure: NoSuchElementException in getUDTs.");
            }
        }
        resultSetArray[0] = SystemProcedures.getDMD().getUDTs(string, string2, string3, nArray);
    }

    public static void METADATA(ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("execute statement SYSIBM.METADATA");
        resultSetArray[0] = preparedStatement.executeQuery();
        connection.close();
    }

    public static void SYSCS_SET_DATABASE_PROPERTY(String string, String string2) throws SQLException {
        PropertyInfo.setDatabaseProperty(string, string2);
    }

    public static String SYSCS_GET_DATABASE_PROPERTY(String string) throws SQLException {
        return PropertyInfo.getDatabaseProperty(string);
    }

    public static void SYSCS_COMPRESS_TABLE(String string, String string2, int n) throws SQLException {
        String string3 = "alter table " + string + "." + string2 + " compress" + (n != 0 ? " sequential" : "");
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.prepareStatement(string3).executeUpdate();
        connection.close();
    }

    public static void SYSCS_FREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().freeze();
    }

    public static void SYSCS_UNFREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().unfreeze();
    }

    public static void SYSCS_CHECKPOINT_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().checkpoint();
    }

    public static void SYSCS_BACKUP_DATABASE(String string) throws SQLException {
        Factory.getDatabaseOfConnection().backup(string);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(String string, int n) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(string, n != 0);
    }

    public static void SYSCS_DISABLE_LOG_ARCHIVE_MODE(int n) throws SQLException {
        Factory.getDatabaseOfConnection().disableLogArchiveMode(n != 0);
    }

    public static void SYSCS_SET_RUNTIMESTATISTICS(int n) throws SQLException {
        ConnectionUtil.getCurrentLCC().setRunTimeStatisticsMode(n != 0);
    }

    public static void SYSCS_SET_STATISTICS_TIMING(int n) throws SQLException {
        ConnectionUtil.getCurrentLCC().setStatisticsTiming(n != 0);
    }

    public static int SYSCS_CHECK_TABLE(String string, String string2) throws SQLException {
        boolean bl = ConsistencyChecker.checkTable(string, string2);
        return bl ? 1 : 0;
    }

    public static String SYSCS_GET_RUNTIMESTATISTICS() throws SQLException {
        RunTimeStatistics runTimeStatistics = ConnectionUtil.getCurrentLCC().getRunTimeStatisticsObject();
        if (runTimeStatistics == null) {
            return null;
        }
        return runTimeStatistics.toString();
    }

    public static void INSTALL_JAR(String string, String string2, int n) throws SQLException {
        try {
            String[] stringArray = IdUtil.parseQualifiedName(string2.trim(), true);
            String string3 = null;
            String string4 = null;
            switch (stringArray.length) {
                case 1: {
                    string3 = null;
                    string4 = stringArray[0];
                    break;
                }
                case 2: {
                    string3 = stringArray[0];
                    string4 = stringArray[1];
                }
            }
            SystemProcedures.checkJarSQLName(string4);
            JarDDL.add(string3, string4, string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void REPLACE_JAR(String string, String string2) throws SQLException {
        try {
            String[] stringArray = IdUtil.parseQualifiedName(string2.trim(), true);
            String string3 = null;
            String string4 = null;
            switch (stringArray.length) {
                case 1: {
                    string3 = null;
                    string4 = stringArray[0];
                    break;
                }
                case 2: {
                    string3 = stringArray[0];
                    string4 = stringArray[1];
                }
            }
            SystemProcedures.checkJarSQLName(string4);
            JarDDL.replace(string3, string4, string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void REMOVE_JAR(String string, int n) throws SQLException {
        try {
            String[] stringArray = IdUtil.parseQualifiedName(string.trim(), true);
            String string2 = null;
            String string3 = null;
            switch (stringArray.length) {
                case 1: {
                    string2 = null;
                    string3 = stringArray[0];
                    break;
                }
                case 2: {
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                }
            }
            SystemProcedures.checkJarSQLName(string3);
            JarDDL.drop(string2, string3);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static void checkJarSQLName(String string) throws StandardException {
        if (string.length() == 0 || string.indexOf(58) != -1) {
            throw StandardException.newException("XCXA0.S");
        }
    }

    public static void SYSCS_EXPORT_TABLE(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Export.exportTable(connection, string, string2, string3, string4, string5, string6);
        connection.commit();
    }

    public static void SYSCS_EXPORT_QUERY(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Export.exportQuery(connection, string, string2, string3, string4, string5);
        connection.commit();
    }

    public static void SYSCS_IMPORT_TABLE(String string, String string2, String string3, String string4, String string5, String string6, short s) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            Import.importTable(connection, string, string2, string3, string4, string5, string6, s);
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        connection.commit();
    }

    public static void SYSCS_IMPORT_DATA(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, short s) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            Import.importData(connection, string, string2, string3, string4, string5, string6, string7, string8, s);
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        connection.commit();
    }

    public static void SYSCS_BULK_INSERT(String string, String string2, String string3, String string4) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        String string5 = string == null ? string2 : string + "." + string2;
        String string6 = "insert into " + string5 + " PROPERTIES insertMode=bulkInsert " + "select * from new " + string3 + "(" + "'" + string + "'" + ", " + "'" + string2 + "'" + ", " + "'" + string4 + "'" + ")" + " as t";
        PreparedStatement preparedStatement = connection.prepareStatement(string6);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }
}

