/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;

public class Introspector {
    private static Vector attributes;
    private static Vector operations;
    private static String className;
    private static Class baseClass;
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Boolean;

    private Introspector() {
    }

    public static final boolean isDynamic(Class clazz) {
        return (class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = Introspector.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(clazz);
    }

    public static void testCreation(Class clazz) throws NotCompliantMBeanException {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isInterface(n)) {
            throw new NotCompliantMBeanException("The MBean must have a concrete class in order to be created remotely.");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("The MBean must have a public constructor in order to be created remotely");
        }
    }

    public static synchronized MBeanInfo testCompliance(Class clazz) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.testCompliance(clazz, null);
    }

    static synchronized MBeanInfo testCompliance(Class clazz, Class clazz2) throws NotCompliantMBeanException {
        if (clazz.isInterface()) {
            throw new NotCompliantMBeanException(clazz.getName() + " must be a class.");
        }
        baseClass = clazz;
        className = clazz.getName();
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        } else {
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new NotCompliantMBeanException(clazz.getName() + " does not implement the " + clazz2.getName() + " interface");
            }
            if (!clazz2.isInterface()) {
                throw new NotCompliantMBeanException(clazz.getName() + ": " + clazz2.getName() + " is not an interface");
            }
        }
        if (clazz2 == null) {
            throw new NotCompliantMBeanException(clazz.getName() + " does not implement the " + clazz.getName() + "MBean interface " + "or the DynamicMBean interface");
        }
        int n = clazz2.getModifiers();
        if (!Modifier.isPublic(n)) {
            throw new NotCompliantMBeanException(clazz2.getName() + " implemented by " + clazz.getName() + " must be public.");
        }
        return Introspector.introspect(clazz2);
    }

    public static synchronized Class getMBeanInterface(Class clazz) {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.getStandardMBeanInterface(clazz);
    }

    static synchronized Class getStandardMBeanInterface(Class clazz) {
        Class clazz2 = clazz;
        Class clazz3 = null;
        while (clazz2 != null) {
            clazz3 = Introspector.findMBeanInterface(clazz2, clazz2.getName());
            if (clazz3 != null) break;
            clazz2 = clazz2.getSuperclass();
        }
        return clazz3;
    }

    private static final Class findMBeanInterface(Class clazz, String string) {
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz3 = Introspector.implementsMBean(classArray[n2], string);
                if (clazz3 != null) {
                    return clazz3;
                }
                ++n2;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MBeanInfo introspect(Class clazz) throws NotCompliantMBeanException {
        attributes = new Vector();
        operations = new Vector();
        Method[] methodArray = null;
        methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            block27: {
                MBeanOperationInfo mBeanOperationInfo;
                int n2;
                Method method;
                block33: {
                    MBeanAttributeInfo mBeanAttributeInfo;
                    Class<?> clazz2;
                    String string;
                    block30: {
                        block32: {
                            block31: {
                                block29: {
                                    block28: {
                                        method = methodArray[n];
                                        if (method == null) break block27;
                                        string = method.getName();
                                        Class<?>[] classArray = method.getParameterTypes();
                                        clazz2 = method.getReturnType();
                                        n2 = classArray.length;
                                        mBeanAttributeInfo = null;
                                        mBeanOperationInfo = null;
                                        if (!string.equals("get") && !string.equals("is") && !string.equals("set")) break block28;
                                        try {
                                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                        operations.addElement(mBeanOperationInfo);
                                        break block27;
                                    }
                                    if (string.startsWith("get") || string.startsWith("set") || string.startsWith("is")) break block29;
                                    try {
                                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    operations.addElement(mBeanOperationInfo);
                                    break block27;
                                }
                                if (n2 != 0) break block30;
                                if (!string.startsWith("get")) break block31;
                                if (clazz2 == Void.TYPE) {
                                    try {
                                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    operations.addElement(mBeanOperationInfo);
                                    break block27;
                                } else {
                                    try {
                                        mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(3), attributeDescription, method, null);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    if (Introspector.testConsistency(mBeanAttributeInfo)) {
                                        attributes.addElement(mBeanAttributeInfo);
                                    }
                                }
                                break block27;
                            }
                            if (clazz2 != (class$java$lang$Boolean == null ? Introspector.class$("java.lang.Boolean") : class$java$lang$Boolean) && clazz2 != Boolean.TYPE || !string.startsWith("is")) break block32;
                            try {
                                mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(2), attributeDescription, method, null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            if (Introspector.testConsistency(mBeanAttributeInfo)) {
                                attributes.addElement(mBeanAttributeInfo);
                            }
                            break block27;
                        }
                        if (!string.startsWith("set")) break block30;
                        try {
                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        operations.addElement(mBeanOperationInfo);
                        break block27;
                    }
                    if (n2 != 1) break block33;
                    if (clazz2 == Void.TYPE && string.startsWith("set")) {
                        try {
                            mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(3), attributeDescription, null, method);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (Introspector.testConsistency(mBeanAttributeInfo)) {
                            attributes.addElement(mBeanAttributeInfo);
                        }
                        break block27;
                    } else {
                        try {
                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        operations.addElement(mBeanOperationInfo);
                    }
                    break block27;
                }
                if (n2 > 1) {
                    try {
                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    operations.addElement(mBeanOperationInfo);
                }
            }
            ++n;
        }
        return Introspector.constructResult();
    }

    private static boolean testConsistency(MBeanAttributeInfo mBeanAttributeInfo) throws NotCompliantMBeanException {
        Enumeration enumeration = attributes.elements();
        while (enumeration.hasMoreElements()) {
            MBeanAttributeInfo mBeanAttributeInfo2 = (MBeanAttributeInfo)enumeration.nextElement();
            if (mBeanAttributeInfo2.getName().compareTo(mBeanAttributeInfo.getName()) != 0) continue;
            if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable() && mBeanAttributeInfo.isIs() != mBeanAttributeInfo2.isIs()) {
                throw new NotCompliantMBeanException("Getter is" + mBeanAttributeInfo2.getName() + " cannot co-exist with getter get" + mBeanAttributeInfo.getName());
            }
            if (mBeanAttributeInfo2.getType().compareTo(mBeanAttributeInfo.getType()) != 0) {
                if (mBeanAttributeInfo2.isWritable() && mBeanAttributeInfo.isWritable()) {
                    throw new NotCompliantMBeanException("Type mismatch between parameters of set" + mBeanAttributeInfo2.getName() + " methods");
                }
                throw new NotCompliantMBeanException("Type mismatch between parameters of get or is" + mBeanAttributeInfo2.getName() + ", set" + mBeanAttributeInfo2.getName() + " methods");
            }
            if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable()) {
                return false;
            }
            if (!mBeanAttributeInfo.isWritable() || !mBeanAttributeInfo2.isWritable()) continue;
            return false;
        }
        return true;
    }

    static MBeanConstructorInfo[] getConstructors() {
        Constructor<?>[] constructorArray = baseClass.getConstructors();
        Vector<MBeanConstructorInfo> vector = new Vector<MBeanConstructorInfo>();
        int n = 0;
        while (n < constructorArray.length) {
            Constructor<?> constructor = constructorArray[n];
            MBeanConstructorInfo mBeanConstructorInfo = null;
            try {
                mBeanConstructorInfo = new MBeanConstructorInfo(constructorDescription, constructor);
            }
            catch (Exception exception) {
                mBeanConstructorInfo = null;
            }
            if (mBeanConstructorInfo != null) {
                vector.addElement(mBeanConstructorInfo);
            }
            ++n;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[vector.size()];
        int n2 = 0;
        while (n2 < mBeanConstructorInfoArray.length) {
            mBeanConstructorInfoArray[n2] = (MBeanConstructorInfo)vector.elementAt(n2);
            ++n2;
        }
        return mBeanConstructorInfoArray;
    }

    private static MBeanInfo constructResult() {
        Cloneable cloneable;
        int n;
        int n2 = 0;
        while (n2 < attributes.size()) {
            MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)attributes.elementAt(n2);
            n = 0;
            while (n < attributes.size()) {
                cloneable = (MBeanAttributeInfo)attributes.elementAt(n);
                if (cloneable.getName().compareTo(mBeanAttributeInfo.getName()) == 0 && n2 != n) {
                    try {
                        attributes.setElementAt(new MBeanAttributeInfo(mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), attributeDescription, true, true, mBeanAttributeInfo.isIs()), n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    attributes.removeElementAt(n2);
                }
                ++n;
            }
            ++n2;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[attributes.size()];
        int n3 = 0;
        while (n3 < attributes.size()) {
            mBeanAttributeInfoArray[n3] = (MBeanAttributeInfo)attributes.elementAt(n3);
            ++n3;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[operations.size()];
        n = 0;
        while (n < operations.size()) {
            mBeanOperationInfoArray[n] = (MBeanOperationInfo)operations.elementAt(n);
            ++n;
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = Introspector.getConstructors();
        cloneable = new MBeanInfo(className, mbeanInfoDescription, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, null);
        return cloneable;
    }

    static Class implementsMBean(Class clazz, String string) {
        if (clazz.getName().compareTo(string + "MBean") == 0) {
            return clazz;
        }
        Class clazz2 = clazz;
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            try {
                if (classArray[n].getName().compareTo(string + "MBean") == 0) {
                    return classArray[n];
                }
            }
            catch (Exception exception) {
                return null;
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        className = null;
        baseClass = null;
    }
}

