/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class WSIProperties {
    protected static Properties wsiProperties = new Properties();
    public static final String DEF_VALIDATOR_FACTORY = "org.wsi.test.profile.validator.impl.ProfileValidatorFactoryImpl";
    public static final String PROP_VALIDATOR_FACTORY = "wsi.profile.validator.factory";
    public static final String DEF_DOCUMENT_FACTORY = "org.wsi.test.document.impl.DocumentFactoryImpl";
    public static final String PROP_DOCUMENT_FACTORY = "wsi.document.factory";
    public static final String DEF_JAXP_DOCUMENT_FACTORY = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    public static final String PROP_JAXP_DOCUMENT_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    public static final String DEF_WSDL_SCHEMA = "common/schemas/wsdl11.xsd";
    public static final String PROP_WSDL_SCHEMA = "wsi.analyzer.wsdl.schema";
    public static final String DEF_WSDL_SOAP_SCHEMA = "common/schemas/wsdlsoap.xsd";
    public static final String PROP_WSDL_SOAP_SCHEMA = "wsi.analyzer.wsdlsoap.schema";
    public static final String DEF_SOAP_SCHEMA = "common/schemas/soapEnvelope.xsd";
    public static final String PROP_SOAP_SCHEMA = "wsi.analyzer.soap.schema";
    public static final String DEF_XML_SCHEMA = "common/schemas/XMLSchema.xsd";
    public static final String PROP_XML_SCHEMA = "wsi.analyzer.xmlschema.schema";
    public static final String PROP_WSI_HOME = "wsi.home";
    protected static final String PROP_FILENAME = "org.wsi.util.wsi";
    private static ThreadLocal threadLocal = new ThreadLocal();

    private static void loadPropertiesFile() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PROP_FILENAME);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                wsiProperties.put(string, resourceBundle.getString(string));
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("WARNING:  Could not read org.wsi.util.wsi.  Verify that it is in the CLASSPATH.");
            wsiProperties.put(PROP_VALIDATOR_FACTORY, DEF_VALIDATOR_FACTORY);
            wsiProperties.put(PROP_DOCUMENT_FACTORY, DEF_DOCUMENT_FACTORY);
            wsiProperties.put(PROP_JAXP_DOCUMENT_FACTORY, DEF_JAXP_DOCUMENT_FACTORY);
        }
    }

    private WSIProperties() {
    }

    public static Properties getThreadLocalProperties() {
        return (Properties)threadLocal.get();
    }

    public static void setThreadLocalProperties(Properties properties) {
        threadLocal.set(properties);
    }

    public static String getProperty(String string) {
        String string2 = null;
        Properties properties = null;
        properties = WSIProperties.getThreadLocalProperties();
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        if (string2 == null) {
            string2 = wsiProperties.getProperty(string);
        }
        return string2;
    }

    public static String getProperty(String string, String string2) {
        String string3 = null;
        string3 = WSIProperties.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            properties.setProperty(PROP_VALIDATOR_FACTORY, "main");
            WSIProperties.setThreadLocalProperties(properties);
            for (int i = 0; i < 5; ++i) {
                new Thread(new ThreadTest("test" + i)).start();
                try {
                    Thread.sleep(200L);
                    System.out.println("PROP_VALIDATOR_FACTORY:  " + WSIProperties.getProperty(PROP_VALIDATOR_FACTORY));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        WSIProperties.loadPropertiesFile();
    }

    private static class ThreadTest
    extends Thread {
        String name;

        ThreadTest(String string) {
            this.name = string;
        }

        public void run() {
            Properties properties = new Properties();
            properties.setProperty(WSIProperties.PROP_VALIDATOR_FACTORY, this.name);
            WSIProperties.setThreadLocalProperties(properties);
            System.out.println("PROP_VALIDATOR_FACTORY:  " + WSIProperties.getProperty(WSIProperties.PROP_VALIDATOR_FACTORY));
        }
    }
}

