/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class StringTokenizer {
    private char[] spaceDel;
    private char[] del;
    private char[] allDel;

    public StringTokenizer(char[] cArray, char[] cArray2) {
        if (cArray != null) {
            this.spaceDel = new char[cArray.length];
            System.arraycopy(cArray, 0, this.spaceDel, 0, cArray.length);
            StringTokenizer.sort(this.spaceDel);
        } else {
            this.spaceDel = null;
        }
        if (cArray2 != null) {
            this.del = new char[cArray2.length];
            System.arraycopy(cArray2, 0, this.del, 0, cArray2.length);
            StringTokenizer.sort(this.del);
        } else {
            this.del = null;
        }
        if (this.del != null && this.spaceDel != null) {
            this.allDel = new char[this.del.length + this.spaceDel.length];
            System.arraycopy(this.del, 0, this.allDel, 0, this.del.length);
            System.arraycopy(this.spaceDel, 0, this.allDel, this.del.length, this.spaceDel.length);
        } else {
            this.allDel = this.del != null ? this.del : this.spaceDel;
        }
        StringTokenizer.sort(this.allDel);
    }

    public Enumeration parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("StringTokenizer : String cannot be NULL");
        }
        return new StringTokenizerEnumeration(string.toCharArray());
    }

    private static boolean contain(char c, char[] cArray) {
        if (cArray == null) {
            return false;
        }
        int n = 0;
        int n2 = cArray.length - 1;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            if (c > cArray[n3]) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return cArray[n] == c;
    }

    private static void sort(char[] cArray) {
        if (cArray != null) {
            char c;
            int n;
            int n2;
            int n3;
            for (n3 = 1; n3 < cArray.length; ++n3) {
                n2 = n3;
                n = (n2 - 1) / 2;
                c = cArray[n3];
                while (n2 > 0 && cArray[n] < c) {
                    cArray[n2] = cArray[n];
                    n2 = n;
                    n = (n2 - 1) / 2;
                }
                cArray[n2] = c;
            }
            for (n3 = cArray.length - 1; n3 > 0; --n3) {
                n = 2;
                n2 = 0;
                c = cArray[0];
                while (n <= n3) {
                    cArray[n2] = cArray[n - 1] > cArray[n] ? cArray[--n] : cArray[n];
                    n2 = n;
                    n = (n2 + 1) * 2;
                }
                cArray[n2] = cArray[n3];
                cArray[n3] = c;
            }
        }
    }

    private class StringTokenizerEnumeration
    implements Enumeration {
        private final char[] str;
        private final int size;
        private int index;
        private String next;

        StringTokenizerEnumeration(char[] cArray) {
            this.str = cArray;
            this.size = this.str.length;
            this.index = 0;
            while (this.index < this.size && StringTokenizer.contain(this.str[this.index], StringTokenizer.this.spaceDel)) {
                ++this.index;
            }
        }

        public boolean hasMoreElements() {
            return this.index < this.size;
        }

        public Object nextElement() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("StringTokenizer enumeration");
            }
            int n = this.index;
            if (this.index < this.size && StringTokenizer.contain(this.str[this.index], StringTokenizer.this.del)) {
                ++this.index;
            }
            if (n == this.index) {
                while (this.index < this.size && !StringTokenizer.contain(this.str[this.index], StringTokenizer.this.allDel)) {
                    ++this.index;
                }
            }
            int n2 = this.index;
            while (this.index < this.size && StringTokenizer.contain(this.str[this.index], StringTokenizer.this.spaceDel)) {
                ++this.index;
            }
            return String.copyValueOf(this.str, n, n2 - n);
        }

        public String toString() {
            int n = this.index;
            String string = (String)this.nextElement();
            this.index = n;
            return string;
        }
    }
}

