/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.document.impl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Document;
import org.wsi.WSIException;
import org.wsi.test.document.DocumentWriter;

public abstract class DocumentWriterImpl
implements DocumentWriter {
    protected Writer writer = null;

    public Document getDocument() throws UnsupportedOperationException {
        return null;
    }

    public void setWriter(String string) throws UnsupportedEncodingException, FileNotFoundException {
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
    }

    public synchronized void write(Reader reader) throws WSIException, IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Could not write document since writer was not set.");
        }
        this.write(reader, this.writer);
    }

    public synchronized void write(Reader reader, Writer writer) throws WSIException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        PrintWriter printWriter = new PrintWriter(writer);
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
        }
        catch (Exception exception) {
            throw new WSIException("Could not write document.", exception);
        }
        printWriter.flush();
    }

    public void close() throws WSIException, IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Could not write log file since writer was not set.");
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new WSIException(iOException.toString(), iOException);
        }
    }
}

