/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.seebeyond.ican;

import hermes.Hermes;
import hermes.HermesException;
import hermes.ext.seebeyond.SeeBeyondAdmin;
import hermes.ext.seebeyond.SunSeeBeyondAbstractAdmin;
import hermes.ext.seebeyond.ican.SeeBeyondICANAdminFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.management.ObjectName;
import mx4j.connector.RemoteMBeanServer;
import mx4j.connector.rmi.jrmp.JRMPConnector;
import org.apache.log4j.Logger;

public class SunSeeBeyond50Admin
extends SunSeeBeyondAbstractAdmin {
    private static final Logger log = Logger.getLogger(SeeBeyondAdmin.class);
    private final RemoteMBeanServer rmiConn;
    private final String jmsServerName;

    public SunSeeBeyond50Admin(SeeBeyondICANAdminFactory factory, Hermes hermes, ConnectionFactory connectionFactory) throws HermesException {
        try {
            long rmiPort = Long.parseLong(factory.getRepositoryPort()) + 4L;
            String connectionURL = "rmi://" + factory.getRepositoryHost() + ":" + rmiPort;
            this.jmsServerName = factory.getJmsIQManagerName();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            properties.put("java.naming.provider.url", connectionURL);
            JRMPConnector connector = new JRMPConnector();
            connector.connect("EM:rmiadaptor=MonitoringService", properties);
            this.rmiConn = connector.getRemoteMBeanServer();
            this.seeBeyondIQManager = new ObjectName("EM:" + factory.getEnvironmentName() + "=" + factory.getLogicalhostName());
        }
        catch (Exception e) {
            log.fatal((Object)"Couldn't connect to the SeeBeyond logical host.");
            throw new HermesException("Please make sure you have added mx4j.jar, mx4j-tools.jar from logicalhost/stcma/lib", e);
        }
    }

    protected Object invoke(String operationName, Object[] params, String[] signatures) throws HermesException {
        try {
            return this.rmiConn.invoke(this.seeBeyondIQManager, operationName, this.addAtTheBeginning(this.jmsServerName, params), (String[])this.addAtTheBeginning("java.lang.String", signatures));
        }
        catch (Exception e) {
            throw new HermesException(e.getMessage(), e);
        }
    }

    private Object[] addAtTheBeginning(Object toAdd, Object[] array) {
        if (array == null) {
            return new String[]{toAdd.toString()};
        }
        int length = array.length + 1;
        Object[] newArray = array[0] instanceof String ? new String[length] : new Object[length];
        newArray[0] = toAdd;
        for (int i = 0; i < array.length; ++i) {
            newArray[i + 1] = array[i];
        }
        return newArray;
    }

    public List getTopics() throws HermesException {
        ArrayList<String> topics = new ArrayList<String>();
        for (Object topicProps : (List)this.invoke("getTopics", null, null)) {
            Properties props = (Properties)topicProps;
            topics.add(props.getProperty("TOPIC_NAME"));
        }
        return topics;
    }

    public List getQueues() throws HermesException {
        ArrayList<String> topics = new ArrayList<String>();
        for (Object topicProps : (List)this.invoke("getQueues", null, null)) {
            Properties props = (Properties)topicProps;
            topics.add(props.getProperty("QUEUE_NAME"));
        }
        return topics;
    }

    public Properties getTopicMsgProperties(String topicName, String messageID) throws HermesException {
        return new Properties();
    }

    public Properties getQueueMsgProperties(String queueName, String messageID) throws HermesException {
        return new Properties();
    }

    public List getSubscribers(String topicName) throws HermesException {
        return new ArrayList();
    }

    public Properties getTopicStatistics(String topicName) throws HermesException {
        Properties topicStats = new Properties();
        for (Object topicProps : (List)this.invoke("getTopics", null, null)) {
            Properties props = (Properties)topicProps;
            if (!topicName.equals(props.getProperty("TOPIC_NAME"))) continue;
            topicStats = props;
        }
        return topicStats;
    }

    public Properties getQueueStatistics(String queueName) throws HermesException {
        Properties queueStats = new Properties();
        for (Object queueProps : (List)this.invoke("getQueues", null, null)) {
            Properties props = (Properties)queueProps;
            if (!queueName.equals(props.getProperty("QUEUE_NAME"))) continue;
            queueStats = props;
        }
        return queueStats;
    }
}

