/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.seebeyond;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.seebeyond.SunSeeBeyondAdminBase;
import hermes.ext.seebeyond.model.SeeBeyondQueue;
import hermes.ext.seebeyond.model.SeeBeyondTopic;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SeeBeyondAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(SeeBeyondAdmin.class);
    protected ConnectionFactory connectionFactory;
    protected HermesAdminFactory factory;
    protected SunSeeBeyondAdminBase seeBeyondAdmin;
    protected DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy hh:mm:ss");

    public SeeBeyondAdmin(Hermes hermes) {
        super(hermes);
    }

    public int getDepth(DestinationConfig dConfig) throws JMSException {
        String destinationName = this.getRealDestinationName(dConfig);
        Properties props = null;
        int depth = 0;
        props = dConfig.getDomain().intValue() == Domain.QUEUE.getId() ? this.seeBeyondAdmin.getQueueStatistics(destinationName) : this.seeBeyondAdmin.getTopicStatistics(destinationName);
        Object count = props.get("MESSAGE_COUNT");
        if (count != null) {
            depth = Integer.parseInt(count.toString());
        }
        return depth;
    }

    public void close() throws JMSException {
    }

    public Collection<DestinationConfig> discoverDestinationConfigs() throws JMSException {
        DestinationConfig dConfig;
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        List queues = this.seeBeyondAdmin.getQueues();
        log.info((Object)"Adding destination queues.");
        boolean addQueues = false;
        boolean addTopics = false;
        if (this.connectionFactory instanceof QueueConnectionFactory) {
            addQueues = true;
        } else if (this.connectionFactory instanceof TopicConnectionFactory) {
            addTopics = true;
        } else {
            addQueues = true;
            addTopics = true;
        }
        if (addQueues) {
            for (Object queue : this.seeBeyondAdmin.getQueues()) {
                String queueName = queue.toString();
                if (queueName.startsWith("STCMS.") || queueName.startsWith("STCTemporary.")) continue;
                log.debug((Object)("Adding queue " + queueName));
                dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                dConfig.setDomain(Integer.valueOf(Domain.QUEUE.getId()));
                dConfig.setName(queueName);
                rval.add(dConfig);
            }
        }
        log.info((Object)"Adding destination queues.");
        if (addTopics) {
            for (Object topic : this.seeBeyondAdmin.getTopics()) {
                String topicName = topic.toString();
                if (topicName.startsWith("STCMS.") || topicName.startsWith("STCTemporary.")) continue;
                log.debug((Object)("Adding topic " + topicName));
                dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                dConfig.setName(topicName);
                rval.add(dConfig);
                log.debug((Object)("Fetching durable subscriptions for topic " + topicName));
                rval.addAll(this.discoverDurableSubscriptions(topicName, null));
            }
        }
        return rval;
    }

    public Map getStatistics(DestinationConfig dConfig) throws JMSException {
        LinkedHashMap<String, String> stats = new LinkedHashMap<String, String>();
        String destinationName = this.getRealDestinationName(dConfig);
        Properties props = null;
        boolean depth = false;
        if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            props = this.seeBeyondAdmin.getQueueStatistics(destinationName);
            SeeBeyondQueue sbQueue = new SeeBeyondQueue(props);
            stats.put("Queue Name", sbQueue.getQueueName());
            stats.put("Min Sequence Number", sbQueue.getMinSequence());
            stats.put("Max Sequence Number", sbQueue.getMaxSequence());
            stats.put("Available Count", sbQueue.getMessageCount());
            stats.put("Number of Receivers", sbQueue.getCurrentReceivers());
            stats.put("Last Published Date/Time", sbQueue.getLastEnqueueTime());
        } else {
            props = this.seeBeyondAdmin.getTopicStatistics(destinationName);
            SeeBeyondTopic sbTopic = new SeeBeyondTopic(props);
            stats.put("Topic Name", sbTopic.getTopicName());
            stats.put("Min Sequence Number", sbTopic.getFirstSequence());
            stats.put("Max Sequence Number", sbTopic.getLastSequence());
            stats.put("Available Count", sbTopic.getMessageCount());
            stats.put("Number of Subscribers", sbTopic.getCurrentSubscribers());
            stats.put("Last Published Date/Time", sbTopic.getLastEnqueueTime());
        }
        return stats;
    }

    protected Collection discoverDurableSubscriptions(String topicName, String jndiName) throws JMSException {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        List subscribers = this.seeBeyondAdmin.getSubscribers(topicName);
        log.debug((Object)("Durable subscriptions for " + topicName + " are " + subscribers));
        for (Object subscriber : subscribers) {
            Properties subscriberProps = (Properties)subscriber;
            DestinationConfig dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
            dConfig.setClientID(subscriberProps.getProperty("SUBSCRIBER_NAME"));
            dConfig.setName(jndiName == null ? "topics/" + topicName : jndiName);
            dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
            dConfig.setSelector(null);
            dConfig.setDurable(Boolean.valueOf(true));
            rval.add(dConfig);
        }
        return rval;
    }

    public long getAge(DestinationConfig dConfig) throws JMSException {
        long rval = 0L;
        String destName = this.getRealDestinationName(dConfig);
        Properties queueStats = null;
        try {
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                queueStats = this.seeBeyondAdmin.getQueueStatistics(destName);
            } else if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                queueStats = this.seeBeyondAdmin.getTopicStatistics(destName);
            } else {
                log.error((Object)("Unsupported destination domain " + dConfig.getDomain()));
            }
            rval = this.dateFormat.parse(queueStats.getProperty("LAST_ENQUEUE_TIME")).getTime();
        }
        catch (Exception e) {
            throw new HermesException("Could not fetch last published time.", e);
        }
        return rval;
    }
}

