/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.util.LittleEndian;

public final class NameXPtg
extends OperandPtg
implements WorkbookDependentFormula {
    public static final short sid = 57;
    private static final int SIZE = 7;
    private final int _sheetRefIndex;
    private final int _nameNumber;
    private final int _reserved;

    private NameXPtg(int sheetRefIndex, int nameNumber, int reserved) {
        this._sheetRefIndex = sheetRefIndex;
        this._nameNumber = nameNumber;
        this._reserved = reserved;
    }

    public NameXPtg(int sheetRefIndex, int nameIndex) {
        this(sheetRefIndex, nameIndex + 1, 0);
    }

    public NameXPtg(RecordInputStream in) {
        this(in.readUShort(), in.readUShort(), in.readUShort());
    }

    public void writeBytes(byte[] array, int offset) {
        LittleEndian.putByte(array, offset + 0, 57 + this.getPtgClass());
        LittleEndian.putUShort(array, offset + 1, this._sheetRefIndex);
        LittleEndian.putUShort(array, offset + 3, this._nameNumber);
        LittleEndian.putUShort(array, offset + 5, this._reserved);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(FormulaRenderingWorkbook book) {
        return book.resolveNameXText(this);
    }

    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public int getSheetRefIndex() {
        return this._sheetRefIndex;
    }

    public int getNameIndex() {
        return this._nameNumber - 1;
    }
}

