/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor.config.impl;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSIFileNotFoundException;
import org.wsi.test.common.impl.AddStyleSheetImpl;
import org.wsi.test.document.DocumentElement;
import org.wsi.test.monitor.config.Comment;
import org.wsi.test.monitor.config.ManInTheMiddle;
import org.wsi.test.monitor.config.MonitorConfig;
import org.wsi.test.monitor.config.MonitorConfigReader;
import org.wsi.test.monitor.config.Redirect;
import org.wsi.test.monitor.config.impl.CommentImpl;
import org.wsi.test.monitor.config.impl.ManInTheMiddleImpl;
import org.wsi.test.monitor.config.impl.MonitorConfigImpl;
import org.wsi.test.monitor.config.impl.RedirectImpl;
import org.wsi.test.util.TestUtils;
import org.wsi.util.MessageList;
import org.wsi.xml.XMLUtils;

public class MonitorConfigReaderImpl
implements MonitorConfigReader {
    protected MessageList messageList = null;
    protected String documentURI;

    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    public MonitorConfig readMonitorConfig(String string) throws WSIException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WSIFileNotFoundException(this.getMessage("config02", string, "Could not find file:"), fileNotFoundException);
        }
        catch (Exception exception) {
            throw new WSIException(this.getMessage("config03", string, "Could not read file:"), exception);
        }
        return this.readMonitorConfig(fileReader);
    }

    public MonitorConfig readMonitorConfig(Reader reader) throws WSIException {
        MonitorConfigImpl monitorConfigImpl = new MonitorConfigImpl();
        Document document = XMLUtils.parseXML(reader);
        this.parseConfigElement(monitorConfigImpl, document.getDocumentElement());
        return monitorConfigImpl;
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String string) {
        this.documentURI = string;
    }

    private void parseConfigElement(MonitorConfig monitorConfig, Element element) throws WSIException {
        Element element2 = XMLUtils.getFirstChild(element);
        boolean bl = false;
        boolean bl2 = false;
        while (element2 != null) {
            DocumentElement documentElement;
            if (this.isElement(element2, "logFile")) {
                this.parseLogFileElement(monitorConfig, element2);
            } else if (this.isElement(element2, "logDuration")) {
                monitorConfig.setLogDuration(this.getIntValue(element2));
                if (monitorConfig.getLogDuration() < 0) {
                    throw new IllegalArgumentException(this.getMessage("config09", "logDuration", "Parameter value can't be negative. Element name:"));
                }
                bl = true;
            } else if (this.isElement(element2, "cleanupTimeoutSeconds")) {
                monitorConfig.setTimeout(this.getIntValue(element2));
                if (monitorConfig.getTimeout() < 0) {
                    throw new IllegalArgumentException(this.getMessage("config09", "cleanupTimeoutSeconds", "Parameter value can't be negative. Element name:"));
                }
                bl2 = true;
            } else if (this.isElement(element2, "manInTheMiddle")) {
                documentElement = new ManInTheMiddleImpl();
                monitorConfig.setManInTheMiddle((ManInTheMiddle)documentElement);
                this.parseManInTheMiddleElement((ManInTheMiddle)documentElement, element2);
            } else if (this.isElement(element2, "comment")) {
                documentElement = new CommentImpl();
                documentElement.setText(XMLUtils.getText(element2));
                monitorConfig.setComment((Comment)documentElement);
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
        if (!bl) {
            throw new IllegalArgumentException(this.getMessage("config10", "logDuration", "Element is missing. Element name:"));
        }
        if (!bl2) {
            throw new IllegalArgumentException(this.getMessage("config10", "cleanupTimeoutSeconds", "Element is missing. Element name:"));
        }
    }

    private void parseLogFileElement(MonitorConfig monitorConfig, Element element) throws WSIException {
        monitorConfig.setLogLocation(XMLUtils.getAttributeValue(element, "location"));
        monitorConfig.setReplaceLog(XMLUtils.getBooleanValue(element, "replace", false));
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            if (this.isElement(element2, "addStyleSheet")) {
                AddStyleSheetImpl addStyleSheetImpl = new AddStyleSheetImpl();
                TestUtils.parseAddStyleSheet(element2, addStyleSheetImpl, "../common/xsl/log.xsl");
                monitorConfig.setAddStyleSheet(addStyleSheetImpl);
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
    }

    private void parseManInTheMiddleElement(ManInTheMiddle manInTheMiddle, Element element) throws WSIException {
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            DocumentElement documentElement;
            if (this.isElement(element2, "redirect")) {
                documentElement = new RedirectImpl();
                manInTheMiddle.addRedirect((Redirect)documentElement);
                this.parseRedirectElement((Redirect)documentElement, element2);
            } else if (this.isElement(element2, "comment")) {
                documentElement = new CommentImpl();
                documentElement.setText(XMLUtils.getText(element2));
                manInTheMiddle.setComment((Comment)documentElement);
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
    }

    private void parseRedirectElement(Redirect redirect, Element element) throws WSIException {
        Element element2 = XMLUtils.getFirstChild(element);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (element2 != null) {
            if (this.isElement(element2, "listenPort")) {
                redirect.setListenPort(this.getIntValue(element2));
                bl = true;
            } else if (this.isElement(element2, "schemeAndHostPort")) {
                redirect.setHost(XMLUtils.getText(element2));
                bl2 = true;
            } else if (this.isElement(element2, "maxConnections")) {
                redirect.setMaxConnections(this.getIntValue(element2));
                bl3 = true;
            } else if (this.isElement(element2, "readTimeoutSeconds")) {
                redirect.setReadTimeoutSeconds(this.getIntValue(element2));
                if (redirect.getReadTimeoutSeconds() < 0) {
                    throw new IllegalArgumentException(this.getMessage("config09", "readTimeoutSeconds", "Parameter value can't be negative. Element name:"));
                }
                bl4 = true;
            } else if (this.isElement(element2, "comment")) {
                CommentImpl commentImpl = new CommentImpl();
                commentImpl.setText(XMLUtils.getText(element2));
                redirect.setComment(commentImpl);
            }
            element2 = XMLUtils.getNextSibling(element2);
        }
        if (!bl) {
            throw new IllegalArgumentException(this.getMessage("config10", "listenPort", "Element is missing. Element name:"));
        }
        if (!bl2) {
            throw new IllegalArgumentException(this.getMessage("config10", "schemeAndHostPort", "Element is missing. Element name:"));
        }
        if (!bl3) {
            throw new IllegalArgumentException(this.getMessage("config10", "maxConnections", "Element is missing. Element name:"));
        }
        if (!bl4) {
            throw new IllegalArgumentException(this.getMessage("config10", "readTimeoutSeconds", "Element is missing. Element name:"));
        }
    }

    private boolean isElement(Element element, String string) {
        return this.isElement(element, "http://www.ws-i.org/testing/2004/07/monitorConfig/", string);
    }

    private boolean isElement(Element element, String string, String string2) {
        return XMLUtils.isElement(element, string, string2);
    }

    private int getIntValue(Element element) throws WSIException {
        String string = null;
        string = XMLUtils.getText(element);
        if (string == null) {
            throw new WSIException(this.getMessage("config04", element.getLocalName() + "Element must contain an integer value:"));
        }
        int n = Integer.valueOf(string);
        return n;
    }

    private String getMessage(String string, String string2) {
        return this.getMessage(string, null, string2);
    }

    private String getMessage(String string, String string2, String string3) {
        String string4 = string3;
        string4 = this.messageList != null ? this.messageList.getMessage(string, string2, string3) : string4 + " " + string2 + ".";
        return string4;
    }
}

