/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import org.wsi.WSIException;
import org.wsi.test.monitor.ChunkedData;
import org.wsi.test.monitor.SocketConnection;
import org.wsi.util.Utils;

public class SocketHandler
extends Thread {
    protected SocketConnection socketConnection;
    protected SocketHandler pairedSocketHandler;
    protected String connectionType;
    protected int conversationID;
    protected String targetHost;
    protected int readTimeoutSeconds;
    protected Socket inSocket;
    protected Socket outSocket;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected boolean verbose = false;
    protected boolean readTimedOut = false;
    private String mimeCharset = null;
    private String xmlEncoding = null;
    protected static final String CRLF = "\r\n";
    protected static final String HTTP_100_CONTINUE = "100 Continue".toUpperCase();
    protected static final String CHUNKED = "Transfer-Encoding: chunked".toUpperCase();
    protected static final String CHUNKED_WITH_QUOTES = "Transfer-Encoding: \"chunked\"".toUpperCase();
    protected static final String CONTENT_LENGTH = "Content-Length:".toUpperCase();

    public SocketHandler(SocketConnection socketConnection, String string, int n, String string2, Socket socket, Socket socket2, int n2) {
        this.socketConnection = socketConnection;
        this.connectionType = string;
        this.conversationID = n;
        this.targetHost = string2;
        this.inSocket = socket;
        this.outSocket = socket2;
        this.readTimeoutSeconds = n2;
        this.verbose = socketConnection.getMonitor().getMonitorConfig().getVerboseOption();
        this.start();
    }

    public void setPairedSocketHandler(SocketHandler socketHandler) {
        this.pairedSocketHandler = socketHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageContext messageContext = null;
        byte[] byArray = new byte[4096];
        try {
            this.inputStream = this.inSocket.getInputStream();
            this.outputStream = this.outSocket.getOutputStream();
            boolean bl = true;
            while (bl) {
                int n = 0;
                messageContext = new MessageContext();
                boolean bl2 = false;
                while (!bl2) {
                    try {
                        this.debug("run", "Read data from the input stream.");
                        n = this.inputStream.read(byArray, 0, byArray.length);
                        this.readTimedOut = false;
                        this.debug("run", "readLen: " + n);
                        if (n == -1) {
                            bl = false;
                            bl2 = true;
                        } else if (n > 0) {
                            String string;
                            Object object;
                            if (messageContext.timestamp == null) {
                                messageContext.timestamp = Utils.getTimestamp();
                            }
                            if (this.connectionType.equals("request")) {
                                object = new String(this.socketConnection.redirect.getToHost() + ":" + this.socketConnection.redirect.getToPort()).getBytes();
                                String string2 = new String(byArray, 0, n);
                                int n2 = string2.indexOf("\r\nHost: ");
                                if (n2 > -1) {
                                    int n3 = string2.indexOf(CRLF, n2 += 8);
                                    this.write(this.outputStream, byArray, 0, n2);
                                    this.write(this.outputStream, (byte[])object, 0, ((Object)object).length);
                                    this.write(this.outputStream, byArray, n3, n - n3);
                                } else {
                                    this.write(this.outputStream, byArray, 0, n);
                                }
                            } else {
                                this.write(this.outputStream, byArray, 0, n);
                            }
                            if (this.verbose) {
                                object = new String(byArray, 0, n);
                                this.debug("run", "buffer as string: [" + (String)object + "]");
                                if (((String)object).length() <= 50) {
                                    this.debug("run", "buffer as hexstring: [" + Utils.toHexString((String)object) + "]");
                                } else {
                                    this.debug("run", "buffer as hexstring: [" + Utils.toHexString(((String)object).substring(0, 50)) + " ...]");
                                }
                            }
                            if (messageContext.bom == 0) {
                                messageContext.bom = this.getBOM(byArray);
                            }
                            this.debug("run", "bom: " + messageContext.bom);
                            try {
                                object = this.getEncoding();
                                string = new String(byArray, 0, n, Utils.getJavaEncoding((String)object));
                                this.setEncoding(string);
                                if (!((String)object).equals(this.getEncoding())) {
                                    object = this.getEncoding();
                                    string = new String(byArray, 0, n, Utils.getJavaEncoding((String)object));
                                }
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.debug("run", "EXCEPTION (3): " + unsupportedEncodingException.toString());
                                throw new RuntimeException(unsupportedEncodingException.toString());
                            }
                            messageContext.encoding = object;
                            this.debug("run", "encoding: " + messageContext.encoding);
                            messageContext = this.processMessage(n, string, messageContext);
                        }
                        if (!this.isMessageComplete(messageContext) && (n != -1 || messageContext.messageBuffer.length() <= 0)) continue;
                        this.logMessage(messageContext);
                        bl2 = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.readTimedOut = true;
                        this.debug("run", "InterruptedIOException: " + interruptedIOException.toString());
                        if (this.pairedSocketHandler == null || !this.pairedSocketHandler.isReadWaiting() || !this.pairedSocketHandler.isReadTimedOut()) continue;
                        this.debug("run", "read timed out on both sockets");
                        if (this.isMessageComplete(messageContext) || messageContext.messageBuffer.length() > 0) {
                            this.logMessage(messageContext);
                        }
                        bl = false;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        this.debug("run", "EXCEPTION (2): " + exception.toString() + "\n" + Utils.getExceptionDetails(exception));
                        if (this.isMessageComplete(messageContext) || messageContext.messageBuffer.length() > 0) {
                            this.logMessage(messageContext);
                        }
                        bl = false;
                        bl2 = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.debug("run", "EXCEPTION (1): " + exception.getMessage() + "\n" + Utils.getExceptionDetails(exception));
        }
        catch (Error error) {
            this.debug("run", "ERROR: " + error.getMessage());
        }
        finally {
            this.shutdown();
            this.socketConnection.wakeUp();
        }
    }

    private MessageContext processMessage(int n, String string, MessageContext messageContext) throws WSIException {
        int n2;
        boolean bl = false;
        MessageContext messageContext2 = messageContext;
        StringBuffer stringBuffer = messageContext2.messageBuffer;
        ChunkedData chunkedData = messageContext2.chunkedData;
        if (string.toUpperCase().indexOf(HTTP_100_CONTINUE) != -1 && n >= 25) {
            this.debug("processMessage", "Ignore HTTP 100 Continue.");
            n2 = string.indexOf("\r\n\r\n");
            if (n2 == string.length() - 4) {
                bl = true;
            } else {
                string = string.substring(n2 + 4);
            }
        }
        if (!bl && this.bypassMessage(string)) {
            this.debug("processMessage", "Do not log message as defined in the monitor spec, but it will be sent.");
            bl = true;
        }
        if (!bl) {
            n2 = 0;
            if (string.toUpperCase().indexOf(CHUNKED) != -1 || string.toUpperCase().indexOf(CHUNKED_WITH_QUOTES) != -1) {
                this.debug("processMessage", "Processing chunked data...");
                n2 = string.indexOf("\r\n\r\n");
                if (n2 == -1) {
                    throw new WSIException("Could not locate end of HTTP header.");
                }
                this.debug("processMessage", "Add header before decoding chunked data: [" + string.substring(0, n2 += 4) + "]");
                stringBuffer.append(string.substring(0, n2));
                if (string.length() == n2) {
                    chunkedData = new ChunkedData(this, true);
                    this.debug("processMessage", "There is chunk data, but none in this part of the message.");
                } else {
                    chunkedData = new ChunkedData(this, string.substring(n2));
                    if (!chunkedData.isMoreChunkedData()) {
                        chunkedData.decodeAndAddDataToBuffer(stringBuffer);
                    }
                }
            } else if (chunkedData != null && chunkedData.isMoreChunkedData()) {
                this.debug("processMessage", "Processing MORE chunked data...");
                chunkedData.addData(string);
                if (!chunkedData.isMoreChunkedData()) {
                    chunkedData.decodeAndAddDataToBuffer(stringBuffer);
                }
            } else {
                this.debug("processMessage", "Add data to message entry buffer: [" + string + "]");
                stringBuffer.append(string);
            }
        }
        messageContext2.messageBuffer = stringBuffer;
        messageContext2.chunkedData = chunkedData;
        return messageContext2;
    }

    protected void stopInput(Socket socket, InputStream inputStream) {
        try {
            if (socket != null) {
                socket.shutdownInput();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        inputStream = null;
    }

    protected void stopOutput(Socket socket, OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.flush();
            }
            if (socket != null) {
                socket.shutdownOutput();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputStream = null;
    }

    public void shutdown() {
        this.stopInput(this.inSocket, this.inputStream);
        this.stopOutput(this.outSocket, this.outputStream);
    }

    void debug(String string, String string2) {
        this.debug("SocketHandler", string, string2);
    }

    void debug(String string, String string2, String string3) {
        if (this.verbose) {
            this.print(string, string2, string3);
        }
    }

    void print(String string, String string2, String string3) {
        System.out.println("[" + Thread.currentThread().getName() + "] [" + string + "." + string2 + "] [" + this.connectionType + "] " + string3);
    }

    private void write(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        if (outputStream == null) {
            this.debug("write", "Could not write buffer because output stream is null.");
        } else {
            this.debug("write", "buffer: [" + new String(byArray, n, n2) + "]");
            outputStream.write(byArray, n, n2);
        }
    }

    private boolean isMessageComplete(MessageContext messageContext) throws WSIException {
        boolean bl = false;
        boolean bl2 = messageContext.chunkedData.isMoreChunkedData();
        String string = messageContext.messageBuffer.toString();
        int n = string.indexOf("\r\n\r\n");
        String string2 = n == -1 ? string : string.substring(0, n + 4);
        if (!(string2.toUpperCase().indexOf(CHUNKED) == -1 && string2.toUpperCase().indexOf(CHUNKED_WITH_QUOTES) == -1 || bl2)) {
            this.debug("isMessageComplete", "HTTP header indicates chunked data and there is no more chunked data");
            bl = true;
        } else {
            n = string2.toUpperCase().indexOf(CONTENT_LENGTH);
            if (n == -1) {
                this.debug("isMessageComplete", "HTTP header does not contain content length");
                bl = string2.startsWith("POST") ? false : string2.startsWith("GET") && string.length() == string2.length() && string.endsWith("\r\n\r\n");
            } else {
                n = string2.toUpperCase().indexOf(CONTENT_LENGTH);
                if (n != -1) {
                    int n2 = string2.indexOf(CRLF, n);
                    this.debug("isMessageComplete", "CRLF: " + Utils.toHexString(CRLF));
                    this.debug("isMessageComplete", "httpHeader/index: " + Utils.toHexString(string2.substring(n)));
                    int n3 = Integer.decode(string2.substring(n + CONTENT_LENGTH.length() + 1, n2));
                    this.debug("isMessageComplete", "contentLen: " + n3);
                    n = string.indexOf("\r\n\r\n");
                    this.debug("isMessageComplete", "actual received message length: " + (string.length() - (n + 4)));
                    if (n3 == string.length() - (n + 4)) {
                        bl = true;
                        this.debug("isMessageComplete", "contentLen = actual received message length.");
                    }
                } else {
                    bl = false;
                }
            }
        }
        this.debug("isMessageComplete", "messageComplete: " + bl);
        return bl;
    }

    private void logMessage(MessageContext messageContext) throws WSIException {
        String string;
        String string2;
        Object var2_2 = null;
        if (this.connectionType.equals("request")) {
            string2 = this.inSocket.getInetAddress().getHostAddress() + ":" + this.inSocket.getPort();
            string = this.targetHost + ":" + this.outSocket.getPort();
        } else {
            string2 = this.targetHost + ":" + this.inSocket.getPort();
            string = this.outSocket.getInetAddress().getHostAddress() + ":" + this.outSocket.getPort();
        }
        this.socketConnection.logMessage(this.conversationID, this.connectionType, messageContext.timestamp, string2, string, messageContext.messageBuffer, messageContext.bom, messageContext.encoding);
    }

    private boolean bypassMessage(String string) {
        boolean bl = false;
        if (string.startsWith("CONNECT") || string.startsWith("TRACE") || string.startsWith("DELETE") || string.startsWith("OPTIONS") || string.startsWith("HEAD")) {
            bl = true;
        }
        return bl;
    }

    private void setEncoding(String string) {
        if (this.mimeCharset == null || this.mimeCharset.length() == 0) {
            this.mimeCharset = Utils.getHTTPCharset(string);
        }
        if (this.xmlEncoding == null || this.xmlEncoding.length() == 0) {
            this.xmlEncoding = Utils.getXMLEncoding(string);
        }
    }

    private String getEncoding() {
        String string = "UTF-8";
        if (this.mimeCharset != null && this.mimeCharset.length() > 0) {
            string = this.mimeCharset;
        }
        if (this.xmlEncoding != null && this.xmlEncoding.length() > 0) {
            string = this.xmlEncoding;
        }
        return string;
    }

    private int getBOM(byte[] byArray) {
        int n = 0;
        byte by = -1;
        byte by2 = -2;
        byte by3 = -17;
        byte by4 = -69;
        byte by5 = -65;
        for (int i = 0; i < byArray.length && n == 0; ++i) {
            if (byArray[i] != 13 || i + 3 >= byArray.length || byArray[i + 1] != 10 || byArray[i + 2] != 13 || byArray[i + 3] != 10) continue;
            this.debug("getBOM", "message[i+4]: " + byArray[i + 4] + ", message[i+5]: " + byArray[i + 5]);
            if (i + 6 < byArray.length && byArray[i + 4] == by3 && byArray[i + 5] == by4 && byArray[i + 6] == by5) {
                n = 0xEFBBBF;
                continue;
            }
            if (i + 5 < byArray.length && byArray[i + 4] == by2 && byArray[i + 5] == by) {
                n = 65279;
                continue;
            }
            if (i + 5 >= byArray.length || byArray[i + 4] != by || byArray[i + 5] != by2) continue;
            n = 65534;
        }
        return n;
    }

    boolean isReadWaiting() {
        boolean bl = false;
        try {
            this.debug("isReadWaiting", "inSocket.getInputStream().available(): " + this.inSocket.getInputStream().available());
            if (this.inSocket.getInputStream().available() == 0) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    boolean isReadTimedOut() {
        return this.readTimedOut;
    }

    class MessageContext {
        StringBuffer messageBuffer = new StringBuffer();
        ChunkedData chunkedData = new ChunkedData();
        String timestamp = null;
        int bom = 0;
        String encoding = "UTF-8";

        MessageContext() {
        }
    }
}

