/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor;

import org.wsi.test.monitor.SocketHandler;

public class ChunkedData {
    protected boolean moreChunkedData = false;
    protected String chunkedData = "";
    protected SocketHandler socketHandler = null;

    public ChunkedData() {
    }

    public ChunkedData(SocketHandler socketHandler, boolean bl) {
        this.socketHandler = socketHandler;
        this.moreChunkedData = bl;
    }

    public ChunkedData(SocketHandler socketHandler, String string) {
        this.socketHandler = socketHandler;
        this.chunkedData = string;
        this.moreChunkedData = this.checkData(string);
    }

    public void addData(String string) {
        this.chunkedData = this.chunkedData + string;
        this.moreChunkedData = this.checkData(string);
    }

    public String getData() {
        return this.chunkedData;
    }

    public void clearData() {
        this.chunkedData = "";
    }

    public boolean isMoreChunkedData() {
        return this.moreChunkedData;
    }

    public boolean decodeAndAddDataToBuffer(StringBuffer stringBuffer) {
        boolean bl = false;
        if (!this.moreChunkedData) {
            this.debug("decodeAndAddDataToBuffer", "chunkedData: " + this.chunkedData);
            bl = this.decodeData(this.chunkedData, stringBuffer);
        }
        return bl;
    }

    private boolean checkData(String string) {
        boolean bl = false;
        int n = string.indexOf("\r\n0\r\n");
        if (n != -1) {
            bl = false;
            this.debug("checkData", "Chunk contains [CRLF][0][CRLF], so there is no more data.");
        } else if (string.startsWith("0\r\n")) {
            bl = false;
            this.debug("checkData", "Chunk data starts with [0][CRLF], so there is no more data.");
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean decodeData(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        while (!bl && n < string.length() && (n = string.indexOf("\r\n", n2)) != -1) {
            String string3 = string.substring(n2, n);
            n3 = Integer.decode("0x" + string3);
            this.debug("decodeData", "chunkedSize: " + n3);
            if (n3 == 0) {
                bl = true;
            } else {
                if (n + 2 + n3 > string.length()) break;
                string2 = string.substring(n + 2, n + 2 + n3);
                this.debug("decodeData", "nextChunkData: " + string2);
                if (stringBuffer != null) {
                    stringBuffer.append(string2);
                }
            }
            n2 = n + 2 + n3 + 2;
        }
        return bl;
    }

    private void debug(String string, String string2) {
        this.socketHandler.debug("ChunkedData", string, string2);
    }
}

