/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.CustomCardLayout;
import com.install4j.runtime.wizard.WizardDialog;
import com.install4j.runtime.wizard.WizardFrame;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class WizardBase
extends JPanel {
    private static final int FRAME_WIDTH = 600;
    private static final int FRAME_HEIGHT = 400;
    private static final int LAYOUT_GAP_WIDTH = 10;
    private static final int LAYOUT_GAP_HEIGHT = 0;
    private String title;
    private WizardFrame wizardFrame;
    private WizardDialog wizardDialog;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private List screens = new LinkedList();
    private ListIterator screenIterator;
    private boolean completed = false;

    public WizardBase(String string) {
        this.title = string;
        this.setupComponent();
    }

    public abstract boolean isSizeClientArea();

    public void showFrame(JFrame jFrame) {
        this.wizardFrame = new WizardFrame(this);
        this.setVisible(true);
    }

    public void showDialog(Window window) {
        this.wizardDialog = WizardDialog.create(this, window);
        this.setVisible(true);
    }

    public Window getWizardWindow() {
        return this.wizardFrame != null ? this.wizardFrame : this.wizardDialog;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean nextScreen() {
        WizardScreen wizardScreen;
        do {
            if (this.screenIterator.hasNext()) continue;
            this.finish();
            return false;
        } while (!(wizardScreen = (WizardScreen)this.screenIterator.next()).supportsNext());
        wizardScreen.activate();
        return true;
    }

    public boolean previousScreen() {
        WizardScreen wizardScreen;
        if (!this.screenIterator.hasPrevious()) {
            return false;
        }
        this.screenIterator.previous();
        do {
            if (this.screenIterator.hasPrevious()) continue;
            return false;
        } while (!(wizardScreen = (WizardScreen)this.screenIterator.previous()).supportsPrevious());
        this.screenIterator.next();
        wizardScreen.activate();
        return true;
    }

    protected boolean isQuitOnWindowClose() {
        return true;
    }

    public boolean isFinishOnWindowClose() {
        return false;
    }

    public void finishFromCloseButton() {
    }

    protected boolean setScreen(WizardScreen wizardScreen) {
        int n = this.screens.indexOf(wizardScreen);
        if (n < 0) {
            return false;
        }
        this.screenIterator = this.screens.listIterator(n);
        this.screenIterator.next();
        wizardScreen.activate();
        return true;
    }

    public List getScreens() {
        return this.screens;
    }

    public void finish() {
        this.completed = true;
        if (this.getWizardWindow() != null) {
            this.setVisible(false);
        }
    }

    public void activateScreen(WizardScreen wizardScreen) {
        this.cardLayout.show(this.cardPanel, wizardScreen.getName());
    }

    public void setVisible(boolean bl) {
        Window window;
        if (bl) {
            this.initVisible();
            this.completed = false;
        }
        if ((window = this.getWizardWindow()) != null) {
            if (bl) {
                this.beforeShow(window);
            } else {
                this.beforeHide(window);
            }
            window.setVisible(bl);
            if (!bl) {
                this.afterHide(window);
                window.dispose();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    protected void initVisible() {
        this.screenIterator = this.screens.listIterator();
        if (this.needsNextScreenOnVisible()) {
            this.nextScreen();
        }
    }

    protected boolean needsNextScreenOnVisible() {
        return true;
    }

    public void cancel() {
        this.completed = true;
        this.setVisible(false);
    }

    protected void beforeShow(Window window) {
    }

    protected void beforeHide(Window window) {
    }

    protected void afterHide(Window window) {
    }

    protected void registerScreen(WizardScreen wizardScreen) {
        if (wizardScreen != null) {
            this.cardPanel.add((Component)wizardScreen, wizardScreen.getName());
            this.screens.add(wizardScreen);
        }
    }

    protected int getFrameWidth() {
        return 600;
    }

    protected int getFrameHeight() {
        return 400;
    }

    protected void setupComponent() {
        this.setName("wizardPanel");
        this.cardLayout = new CustomCardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)this.cardPanel, "Center");
    }

    public void prepareWindow(final Window window) {
        this.setTitle(this.getTitle());
        GUIHelper.setIconImages(window);
        if (this.isMacOS()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 0));
        }
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (WizardBase.this.isQuitOnWindowClose()) {
                    WizardBase.this.cancel();
                } else if (WizardBase.this.isFinishOnWindowClose()) {
                    WizardBase.this.finishFromCloseButton();
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (InstallerUtil.isUpToJava15()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int n = window.getWidth();
                            int n2 = window.getHeight();
                            window.setSize(n + 1, n2);
                            window.validate();
                            window.setSize(n, n2);
                            window.validate();
                        }
                    });
                }
                Toolkit.getDefaultToolkit().sync();
                window.toFront();
            }
        });
    }

    private boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }
}

