/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.WinLauncher;
import com.exe4j.runtime.util.ArgumentStack;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.ErrorHandler;
import com.install4j.runtime.launcher.FirstRun;
import com.install4j.runtime.launcher.LauncherConstants;
import com.install4j.runtime.launcher.LauncherIntegration;
import com.install4j.runtime.launcher.LauncherVariables;
import com.install4j.runtime.launcher.SplashEngine;
import com.install4j.runtime.splashscreen.SplashScreenConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class Launcher
implements LauncherConstants {
    private static final int POLLING_PERIOD = 1000;
    private static final int RUNNING_MULTIPLIER = 10;
    private static final int STOP_TIMEOUT_SECONDS = Integer.getInteger("install4j.daemonTimeout", 60);
    private static final int NO_PID_STARTED = 44;
    private static final int PID_STARTED = 43;
    private static File watcherFile = null;
    private static boolean service = false;
    private static SplashScreenConfig splashScreenConfig;
    private static String[] originalArgs;

    public static void main(String[] stringArray) {
        block12: {
            if (!FirstRun.checkFirstRun()) {
                return;
            }
            LauncherVariables.init(Launcher.class, stringArray);
            LauncherIntegration.checkIntegrations();
            try {
                ArgumentStack argumentStack = new ArgumentStack(stringArray);
                String string = argumentStack.popString();
                if (string.equals("stop")) {
                    Launcher.setStop();
                    break block12;
                }
                if (string.equals("status")) {
                    Launcher.reportStatus();
                    break block12;
                }
                String string2 = argumentStack.popString();
                boolean bl = argumentStack.popBoolean();
                ErrorHandler.setIsGuiApplication(bl);
                boolean bl2 = argumentStack.popBoolean();
                String string3 = argumentStack.popString();
                String string4 = argumentStack.popString();
                boolean bl3 = argumentStack.popBoolean();
                try {
                    splashScreenConfig = new SplashScreenConfig(argumentStack);
                    originalArgs = Launcher.getArgumentArray(argumentStack);
                }
                catch (Exception exception) {
                    originalArgs = new String[0];
                    splashScreenConfig = new SplashScreenConfig(false);
                }
                if (string.equals("launch")) {
                    if (!string2.startsWith("com.install4j.runtime")) {
                        SplashEngine.showSplashScreen(splashScreenConfig, bl2);
                    }
                    LauncherEngine.launch(string2, originalArgs, string3, string4, bl3, bl, ClassLoader.getSystemClassLoader());
                } else if (string.equals("start")) {
                    if (bl2) {
                        System.out.println("This daemon was created with an evaluation version of install4j.");
                    }
                    Launcher.setStart();
                    LauncherEngine.launch(string2, originalArgs, string3, string4, bl3, bl, ClassLoader.getSystemClassLoader());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ErrorHandler.reportError(exception.toString());
                System.exit(1);
            }
        }
    }

    private static String[] getArgumentArray(ArgumentStack argumentStack) {
        int n = argumentStack.popInt();
        if (n == -1) {
            n = argumentStack.size();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string = argumentStack.popString();
            if (Boolean.getBoolean("i4j.vpt") && string.startsWith("-J")) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void reportStatus() {
        if (Launcher.isRunning()) {
            System.out.println("The daemon is running.");
            System.exit(0);
        } else {
            System.out.println("The daemon is stopped.");
            System.exit(3);
        }
    }

    public static boolean isService() {
        return service || WinLauncher.isService();
    }

    private static void setStart() {
        service = true;
        File file = Launcher.getWatcherFile();
        if (Launcher.isRunning()) {
            System.out.println("The daemon seems to be running. Exiting. Id file: " + file);
            System.exit(1);
        }
        if (file.exists() && !file.delete()) {
            System.out.println("Could not delete id file " + file + ". Aborting.");
            System.exit(1);
        }
        Launcher.createStartFile(file);
        new StopWatcherThread().start();
    }

    private static void createStartFile(File file) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            int n = VersionSpecificHelper.getPid();
            if (n == 0) {
                dataOutputStream.write(44);
            } else {
                dataOutputStream.write(43);
                dataOutputStream.writeInt(n);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not create id file " + file + ". Aborting.");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRunning() {
        File file = Launcher.getWatcherFile();
        if (!file.exists()) return false;
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            try {
                int n;
                int n2 = dataInputStream.read();
                if (n2 == 43 && (n = dataInputStream.readInt()) > 0) {
                    boolean bl = Launcher.killProcess(0, n);
                    return bl;
                }
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (System.currentTimeMillis() - file.lastModified() >= 10000L) return false;
        return true;
    }

    private static boolean killProcess(int n, int n2) throws InterruptedException, IOException {
        return Runtime.getRuntime().exec("kill -s " + n + " " + n2).waitFor() == 0;
    }

    private static File getWatcherFile() {
        if (watcherFile == null) {
            String string = System.getProperty("exe4j.moduleName");
            if (string == null) {
                string = ResourceHelper.getRuntimeDir().getAbsolutePath();
            } else {
                try {
                    string = new File(string).getCanonicalFile().getAbsolutePath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String string2 = System.getProperty("install4j.pidDir", "/tmp") + "/i4jdaemon_" + string.replace('/', '_');
            watcherFile = new File(string2);
        }
        return watcherFile;
    }

    private static void setStop() {
        if (!Launcher.isRunning()) {
            System.out.println("The daemon is not running.");
            System.exit(0);
        }
        File file = Launcher.getWatcherFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            for (int i = 0; i < 20; ++i) {
                fileOutputStream.write(33);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not stop daemon.");
            System.exit(1);
        }
        for (int i = 0; i < 5 * STOP_TIMEOUT_SECONDS && Launcher.isRunning(); ++i) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (Launcher.isRunning()) {
            System.out.println("Timeout. Daemon did not shutdown yet.");
            System.exit(1);
        } else {
            if (!file.delete() && file.exists()) {
                file.deleteOnExit();
            }
            System.out.println("Stopped.");
            System.exit(0);
        }
    }

    private Launcher() {
    }

    public static String[] appendOriginalArgs(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + originalArgs.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        System.arraycopy(originalArgs, 0, stringArray2, stringArray.length, originalArgs.length);
        return stringArray2;
    }

    public static void showDelayedSlashScreen() {
        if (splashScreenConfig != null) {
            SplashEngine.showSplashScreen(splashScreenConfig, false);
        }
    }

    private static class StopWatcherThread
    extends Thread {
        public StopWatcherThread() {
            this.setDaemon(true);
        }

        public void run() {
            File file = Launcher.getWatcherFile();
            file.deleteOnExit();
            while (true) {
                try {
                    StopWatcherThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!file.exists()) {
                    Launcher.createStartFile(file);
                }
                if (file.length() > 10L) {
                    System.exit(0);
                    continue;
                }
                file.setLastModified(System.currentTimeMillis());
            }
        }
    }
}

