/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.BaselineSizeGroupComponentWrapper;
import com.install4j.runtime.installer.helper.versionspecific.Console16Access;
import com.install4j.runtime.installer.helper.versionspecific.ConsoleAccess;
import com.install4j.runtime.installer.helper.versionspecific.Java15Helper;
import com.install4j.runtime.installer.helper.versionspecific.SizeGroupComponentWrapper;
import java.awt.Desktop;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;

public class Java16Helper
extends Java15Helper {
    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            return -1;
        }
        return jComponent.getBaseline(n, n2);
    }

    @Override
    public void setIconImages(List list, Window window) {
        window.setIconImages(list);
    }

    @Override
    public ConsoleAccess createConsoleAccess() {
        if (System.console() == null) {
            return super.createConsoleAccess();
        }
        return new Console16Access();
    }

    @Override
    public SizeGroupComponentWrapper createSizeGroupComponentWrapper(JComponent jComponent) {
        return new BaselineSizeGroupComponentWrapper(jComponent);
    }

    @Override
    public boolean showUrlWithDesktop(String string) throws IOException {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(GUIHelper.encodeSpaces(string)));
            return true;
        }
        catch (IOException iOException) {
            Logger.getInstance().error(this, "The URI " + string + " cannot be shown.");
            Logger.getInstance().log(iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            Logger.getInstance().error(this, "The URI " + string + " cannot be shown.");
            Logger.getInstance().log(throwable);
            throw new IOException(throwable);
        }
    }

    @Override
    public boolean canExecute(File file) {
        return file.canExecute();
    }

    @Override
    public TransformerFactory createTransformerFactory() {
        try {
            return TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        }
        catch (Throwable throwable) {
            return super.createTransformerFactory();
        }
    }

    @Override
    public DocumentBuilderFactory createDocumentBuilderFactory() {
        try {
            return DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
        }
        catch (Throwable throwable) {
            return super.createDocumentBuilderFactory();
        }
    }
}

