/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDisplay
extends JPanel {
    private static final String PROPERTY_XP_INDETERMINATE = "install4j.xpIndeterminate";
    private static boolean JAVA_1_6_AND_HIGHER;
    private JLabel lblStatus;
    private JLabel lblDetail;
    private JProgressBar progressBar;
    private IndeterminateUpdaterThread indeterminateUpdaterThread;
    private GridBagConstraints gc;
    private int percentCompleted = 0;
    private int secondaryPercentCompleted = 0;
    private String lastDetailMessage;
    private boolean progressBarSizeWorkaround;

    public ProgressDisplay() {
        this.setupControls();
        this.setupComponent();
    }

    public void setStatusMessage(final String string) {
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.lblStatus.setText(string.length() == 0 ? " " : string);
            }
        });
    }

    public void setDetailMessage(final String string) {
        this.lastDetailMessage = string;
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.lblDetail.setText(string.length() == 0 ? " " : string);
            }
        });
    }

    public void setStatusVisible(final boolean bl) {
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.lblStatus.setVisible(bl);
            }
        });
    }

    public void setDetailVisible(final boolean bl) {
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.lblDetail.setVisible(bl);
            }
        });
    }

    public void setPercentCompleted(final int n) {
        if (this.percentCompleted == n) {
            return;
        }
        this.percentCompleted = n <= 100 ? n : 100;
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.progressBar.setValue(n);
            }
        });
    }

    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void setupControls() {
        this.lblStatus = new JLabel(" ");
        this.lblDetail = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0, 100);
        boolean bl = this.progressBarSizeWorkaround = Boolean.getBoolean("install4j.progressBarWorkaround") || Util.isWindows2012();
        if (this.progressBarSizeWorkaround) {
            this.progressBar.setPreferredSize(new Dimension(100, 15));
        }
    }

    public void setEnabled(final boolean bl) {
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.setTextLinesEnabled(bl);
            }
        });
    }

    public void setTextLinesEnabled(final boolean bl) {
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                ProgressDisplay.this.lblStatus.setEnabled(bl);
                ProgressDisplay.this.lblDetail.setEnabled(bl);
            }
        });
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        this.gc = new GridBagConstraints();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.fill = 2;
        this.add((Component)this.lblStatus, this.gc);
        ++this.gc.gridy;
        this.add((Component)this.lblDetail, this.gc);
        ++this.gc.gridy;
        this.gc.insets.top = 3;
        this.gc.insets.bottom = 3;
        this.add((Component)this.progressBar, this.gc);
        ++this.gc.gridy;
    }

    public void setIndeterminateProgress(final boolean bl) {
        if (!this.isEmulate()) {
            GUIHelper.invokeLater(new Runnable(){

                public void run() {
                    ProgressDisplay.this.setIndeterminateInternal(bl);
                }
            });
        }
        if (!bl) {
            if (this.indeterminateUpdaterThread == null) {
                return;
            }
            this.indeterminateUpdaterThread.cancel();
            try {
                this.indeterminateUpdaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            GUIHelper.invokeLater(new Runnable(){

                public void run() {
                    ProgressDisplay.this.setPercentCompleted(ProgressDisplay.this.percentCompleted);
                }
            });
            this.indeterminateUpdaterThread = null;
        } else {
            if (this.indeterminateUpdaterThread != null) {
                return;
            }
            this.indeterminateUpdaterThread = new IndeterminateUpdaterThread();
            this.indeterminateUpdaterThread.start();
        }
    }

    private void setIndeterminateInternal(boolean bl) {
        if (JAVA_1_6_AND_HIGHER && !this.progressBarSizeWorkaround) {
            this.progressBar.setPreferredSize(null);
            if (bl) {
                Dimension dimension = this.progressBar.getPreferredSize();
                --dimension.height;
                this.progressBar.setPreferredSize(dimension);
            }
            this.progressBar.invalidate();
            this.validate();
        }
        this.progressBar.setIndeterminate(bl);
    }

    private boolean isEmulate() {
        return GUIHelper.isWindowsXpLaF() && !Boolean.getBoolean(PROPERTY_XP_INDETERMINATE) && !JAVA_1_6_AND_HIGHER;
    }

    public void activate() {
    }

    public void setSecondaryPercentCompleted(final int n) {
        if (this.secondaryPercentCompleted == n || n < 0) {
            return;
        }
        this.secondaryPercentCompleted = n;
        GUIHelper.invokeLater(new Runnable(){

            public void run() {
                if (!ProgressDisplay.this.lblDetail.isVisible()) {
                    ProgressDisplay.this.setDetailVisible(true);
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (ProgressDisplay.this.lastDetailMessage != null && ProgressDisplay.this.lastDetailMessage.trim().length() > 0) {
                    stringBuffer.append(ProgressDisplay.this.lastDetailMessage);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("(");
                stringBuffer.append(n);
                stringBuffer.append(" %)");
                ProgressDisplay.this.lblDetail.setText(stringBuffer.toString());
            }
        });
    }

    static {
        String string = System.getProperty("java.version");
        JAVA_1_6_AND_HIGHER = !string.startsWith("1.2") && !string.startsWith("1.3") && !string.startsWith("1.4") && !string.startsWith("1.5");
    }

    private class IndeterminateUpdaterThread
    extends Thread {
        private boolean canceled;

        private IndeterminateUpdaterThread() {
        }

        public void run() {
            while (!this.canceled) {
                for (int i = 0; i <= 100; i += 5) {
                    final int n = i;
                    if (ProgressDisplay.this.isEmulate()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ProgressDisplay.this.progressBar.setValue(n);
                            }
                        });
                    }
                    try {
                        Thread.sleep(80L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

