/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.ProgressDisplay;
import com.install4j.runtime.installer.frontend.headless.UnattendedScreenExecutor;
import com.install4j.runtime.util.CustomDialog;
import com.install4j.runtime.wizard.CustomFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SplashProgressInterface
implements UnattendedProgressInterface {
    private static final int FRAME_WIDTH = 350;
    private final GUIProgressInterface guiProgressInterface = new GUIProgressInterface();
    private ProgressDisplay progressDisplay;
    private boolean userConfirmations;
    private boolean quietOverwrite;
    private UnattendedScreenExecutor unattendedScreenExecutor;
    private JPanel cancelButtonPanel;
    private JButton btnCancel;
    private Window window;

    public SplashProgressInterface(String string, boolean bl, boolean bl2, UnattendedScreenExecutor unattendedScreenExecutor, boolean bl3, Window window) {
        JPanel jPanel;
        this.userConfirmations = bl;
        this.quietOverwrite = bl2;
        this.unattendedScreenExecutor = unattendedScreenExecutor;
        this.btnCancel = new JButton(Messages.getMessages().getString("ButtonCancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SplashProgressInterface.this.btnCancel.isEnabled() && SplashProgressInterface.this.btnCancel.isVisible()) {
                    SplashProgressInterface.this.doCancel();
                }
            }
        });
        this.progressDisplay = new ProgressDisplay();
        this.cancelButtonPanel = new JPanel(new BorderLayout());
        this.cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.cancelButtonPanel.add((Component)this.btnCancel, "South");
        if (bl3) {
            SplashScreenDialog splashScreenDialog = SplashScreenDialog.create(window);
            this.window = splashScreenDialog;
            jPanel = (JPanel)splashScreenDialog.getContentPane();
        } else {
            this.window = new SplashScreenFrame();
            SplashScreenFrame splashScreenFrame = (SplashScreenFrame)this.window;
            jPanel = (JPanel)splashScreenFrame.getContentPane();
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.progressDisplay, "Center");
        if (unattendedScreenExecutor != null) {
            jPanel.add((Component)this.cancelButtonPanel, "East");
        }
        if (this.window instanceof SplashScreenDialog) {
            ((SplashScreenDialog)this.window).init(string);
        } else {
            ((SplashScreenFrame)this.window).init(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel() {
        ContextImpl.setAskingForCancel(true);
        try {
            this.btnCancel.setEnabled(false);
            ContextImpl.setCancelling();
            this.unattendedScreenExecutor.getCommandSink().returnToController(ControllerCommand.CANCEL);
        }
        finally {
            ContextImpl.setAskingForCancel(false);
        }
    }

    public void setStatusMessage(String string) {
        this.progressDisplay.setStatusMessage(string);
    }

    public void setDetailMessage(String string) {
        this.progressDisplay.setDetailMessage(string);
    }

    public void setPercentCompleted(int n) {
        this.progressDisplay.setPercentCompleted(n);
    }

    public int getPercentCompleted() {
        return this.progressDisplay.getPercentCompleted();
    }

    public void setSecondaryPercentCompleted(int n) {
        this.progressDisplay.setSecondaryPercentCompleted(n);
    }

    public void setIndeterminateProgress(boolean bl) {
        this.progressDisplay.setIndeterminateProgress(bl);
    }

    public void showFailure(String string) {
        if (this.userConfirmations) {
            this.guiProgressInterface.showFailure(string);
        }
    }

    public int askOverwrite(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askOverwrite(file);
        }
        if (this.quietOverwrite) {
            return 2;
        }
        return 1;
    }

    public int askRetry(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askRetry(file);
        }
        return 1;
    }

    public boolean askContinue(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askContinue(file);
        }
        return true;
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.btnCancel.setEnabled(bl);
    }

    public void setCancelButtonVisible(boolean bl) {
        this.cancelButtonPanel.setVisible(bl);
    }

    public boolean isAskForProxy() {
        return true;
    }

    public void setVisible(boolean bl) {
        this.window.setVisible(bl);
        if (!bl) {
            this.window.dispose();
        }
    }

    private static class SplashScreenDialog
    extends CustomDialog {
        static SplashScreenDialog create(Window window) {
            if (window instanceof Dialog) {
                return new SplashScreenDialog((Dialog)window);
            }
            if (window instanceof Frame) {
                return new SplashScreenDialog((Frame)window);
            }
            return new SplashScreenDialog((Frame)null);
        }

        private SplashScreenDialog(Frame frame) {
            super(frame);
        }

        private SplashScreenDialog(Dialog dialog) {
            super(dialog);
        }

        protected int getFrameHeight() {
            return -1;
        }

        protected int getFrameWidth() {
            return 350;
        }

        public void init(String string) {
            this.setTitle(string);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setBounds(this.getFrameBounds());
            GUIHelper.setIconImages(this);
        }
    }

    private static class SplashScreenFrame
    extends CustomFrame {
        private SplashScreenFrame() {
        }

        protected int getFrameHeight() {
            return -1;
        }

        protected int getFrameWidth() {
            return 350;
        }

        public void init(String string) {
            this.setTitle(string);
            this.setDefaultCloseOperation(0);
            this.setResizable(false);
            this.pack();
            this.setBounds(this.getNewFrameBounds());
            GUIHelper.setIconImages(this);
        }
    }
}

