/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.EntryStruct;
import com.tonicsystems.jarjar.JarProcessor;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Wildcard;
import java.io.IOException;
import java.util.List;

class ZapProcessor
implements JarProcessor {
    private Wildcard[] wildcards;

    public ZapProcessor(List zapList) {
        this.wildcards = PatternElement.createWildcards(zapList);
    }

    public boolean process(EntryStruct struct) throws IOException {
        if (struct.name.endsWith(".class")) {
            return !this.zap("L" + struct.name.substring(0, struct.name.length() - 6) + ";");
        }
        return true;
    }

    private boolean zap(String desc) {
        for (int i = 0; i < this.wildcards.length; ++i) {
            if (!this.wildcards[i].matches(desc, 0)) continue;
            return true;
        }
        return false;
    }
}

