/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepFind;
import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.MainProcessor;
import com.tonicsystems.jarjar.NestedException;
import com.tonicsystems.jarjar.RulesFileParser;
import com.tonicsystems.jarjar.StandaloneJarProcessor;
import com.tonicsystems.jarjar.StringDumper;
import com.tonicsystems.jarjar.TextDepHandler;
import com.tonicsystems.jarjar.gnu.getopt.Getopt;
import com.tonicsystems.jarjar.gnu.getopt.LongOpt;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class Main {
    public static final int STYLE_SIMPLE = 0;
    private static final String HELP;
    private boolean verbose;
    private List patterns;
    private int level = 0;
    private int style = 0;
    static /* synthetic */ Class class$com$tonicsystems$jarjar$Main;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            Main.help();
            return;
        }
        Getopt g = new Getopt("jarjar", args, ":fhvs", new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("verbose", 0, null, 118), new LongOpt("rules", 1, null, 2), new LongOpt("find", 0, null, 102), new LongOpt("strings", 0, null, 115), new LongOpt("level", 1, null, 3), new LongOpt("style", 1, null, 4)});
        boolean find = false;
        boolean strings = false;
        try {
            int c;
            Main main = new Main();
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 2: {
                        main.setRules(new File(g.getOptarg()));
                        break;
                    }
                    case 3: {
                        String level = g.getOptarg();
                        if ("jar".equals(level)) {
                            main.setLevel(1);
                            break;
                        }
                        if ("class".equals(level)) {
                            main.setLevel(0);
                            break;
                        }
                        throw new IllegalArgumentException("unknown level " + level);
                    }
                    case 4: {
                        String style = g.getOptarg();
                        if ("simple".equals(style)) {
                            main.setStyle(0);
                            break;
                        }
                        throw new IllegalArgumentException("unknown style " + style);
                    }
                    case 115: {
                        strings = true;
                        break;
                    }
                    case 102: {
                        find = true;
                        break;
                    }
                    case 104: {
                        Main.help();
                        return;
                    }
                    case 118: {
                        main.setVerbose(true);
                    }
                }
            }
            if (find && strings) {
                throw new IllegalArgumentException("find and strings cannot be used together");
            }
            int index = g.getOptind();
            int argCount = args.length - index;
            if (argCount == 2) {
                if (find) {
                    main.find(args[index], args[index + 1]);
                } else {
                    main.run(args[index], args[index + 1]);
                }
            } else if (find) {
                main.find(args[index]);
            } else if (strings) {
                main.strings(args[index]);
            } else {
                System.err.println("jarjar: expected two arguments");
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("jarjar: " + e.getMessage());
            return;
        }
    }

    private static void help() {
        System.err.print(HELP);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setRules(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("rules cannot be null");
        }
        this.patterns = RulesFileParser.parse(file);
    }

    public void setRules(List rules) {
        this.patterns = new ArrayList(rules);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void find(String arg) throws IOException {
        this.find(arg, arg);
    }

    public void find(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (this.patterns != null) {
            throw new IllegalArgumentException("rules cannot be used with find");
        }
        PrintWriter w = new PrintWriter(System.out);
        TextDepHandler handler = new TextDepHandler(w, this.level);
        new DepFind().run(from, to, handler);
        w.flush();
    }

    public void strings(String arg) throws IOException {
        if (arg == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (this.patterns != null) {
            throw new IllegalArgumentException("rules cannot be used with strings");
        }
        new StringDumper().run(arg, new PrintWriter(System.out));
    }

    public void run(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        if (this.patterns == null) {
            throw new IllegalArgumentException("rules are required");
        }
        MainProcessor proc = new MainProcessor(this.patterns, this.verbose);
        StandaloneJarProcessor.run(new File(from), new File(to), proc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            HELP = IoUtils.readIntoString((class$com$tonicsystems$jarjar$Main == null ? (class$com$tonicsystems$jarjar$Main = Main.class$("com.tonicsystems.jarjar.Main")) : class$com$tonicsystems$jarjar$Main).getResourceAsStream("help.txt"));
        }
        catch (IOException e) {
            throw new NestedException(e);
        }
    }
}

