/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.ClassHeaderReader;
import com.tonicsystems.jarjar.ClassPathIterator;
import com.tonicsystems.jarjar.DepFindVisitor;
import com.tonicsystems.jarjar.DepHandler;
import com.tonicsystems.jarjar.WrappedIOException;
import com.tonicsystems.jarjar.asm.ClassReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class DepFind {
    private File curDir = new File(System.getProperty("user.dir"));

    public void setCurrentDirectory(File curDir) {
        this.curDir = curDir;
    }

    public void run(String from, String to, DepHandler handler) throws IOException {
        try {
            Object cls;
            HashMap<String, Object> classes = new HashMap<String, Object>();
            ClassPathIterator cp = new ClassPathIterator(this.curDir, to);
            while (cp.hasNext()) {
                cls = cp.next();
                classes.put(new ClassHeaderReader(cp.getInputStream(cls)).getClassName(), cp.getSource(cls));
            }
            cp.close();
            handler.handleStart();
            cp = new ClassPathIterator(this.curDir, from);
            while (cp.hasNext()) {
                cls = cp.next();
                Object source = cp.getSource(cls);
                new ClassReader(cp.getInputStream(cls)).accept(new DepFindVisitor(classes, source, handler), true);
            }
            cp.close();
            handler.handleEnd();
        }
        catch (WrappedIOException e) {
            throw (IOException)e.getCause();
        }
    }
}

